/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.util.BitMask;
import de.caff.util.BitMaskUtil;
import java.util.BitSet;

public final class BitSetBitMask
implements BitMask {
    public static final BitSetBitMask ZERO = new BitSetBitMask(new BitSet());
    @NotNull
    private final BitSet bitSet;

    private BitSetBitMask(boolean bl, @NotNull BitSet bitSet) {
        this.bitSet = bl ? (BitSet)bitSet.clone() : bitSet;
    }

    public BitSetBitMask(@NotNull BitSet bitSet) {
        this(true, bitSet);
    }

    public BitSetBitMask(int n) {
        this(false, new BitSet(n));
    }

    @Override
    public boolean isSet(int n) {
        return this.bitSet.get(n);
    }

    @Override
    public int getBitCount() {
        return this.bitSet.size();
    }

    @Override
    public int getCardinality() {
        return this.bitSet.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    @Override
    @NotNull
    public BitMask set(int n) {
        if (this.isSet(n)) {
            return this;
        }
        BitSet bitSet = (BitSet)this.bitSet.clone();
        bitSet.set(n);
        return new BitSetBitMask(false, bitSet);
    }

    @Override
    @NotNull
    public BitMask clear(int n) {
        if (!this.isSet(n)) {
            return this;
        }
        BitSet bitSet = (BitSet)this.bitSet.clone();
        bitSet.clear(n);
        return new BitSetBitMask(false, bitSet);
    }

    @Override
    @NotNull
    public BitMask flip(int n) {
        BitSet bitSet = (BitSet)this.bitSet.clone();
        bitSet.flip(n);
        return new BitSetBitMask(false, bitSet);
    }

    @Override
    @NotNull
    public BitMask not() {
        BitSet bitSet = (BitSet)this.bitSet.clone();
        bitSet.flip(0, bitSet.length());
        return new BitSetBitMask(false, bitSet);
    }

    @Override
    @NotNull
    public BitMask and(@NotNull BitMask bitMask) {
        BitSet bitSet = (BitSet)this.bitSet.clone();
        bitSet.and(bitMask.toBitSet());
        return new BitSetBitMask(false, bitSet);
    }

    @Override
    @NotNull
    public BitMask andNot(@NotNull BitMask bitMask) {
        BitSet bitSet = (BitSet)this.bitSet.clone();
        bitSet.andNot(bitMask.toBitSet());
        return new BitSetBitMask(false, bitSet);
    }

    @Override
    @NotNull
    public BitMask or(@NotNull BitMask bitMask) {
        BitSet bitSet = (BitSet)this.bitSet.clone();
        bitSet.or(bitMask.toBitSet());
        return new BitSetBitMask(false, bitSet);
    }

    @Override
    @NotNull
    public BitMask xor(@NotNull BitMask bitMask) {
        BitSet bitSet = (BitSet)this.bitSet.clone();
        bitSet.xor(bitMask.toBitSet());
        return new BitSetBitMask(false, bitSet);
    }

    @Override
    @NotNull
    public BitSet toBitSet() {
        return (BitSet)this.bitSet.clone();
    }

    @Override
    public int low32() {
        return (int)this.low64();
    }

    @Override
    public long low64() {
        return this.getBitCount() > 0 ? this.bitSet.toLongArray()[0] : 0L;
    }

    @Override
    public int getLowestBitSet() {
        return this.bitSet.nextSetBit(0);
    }

    @Override
    public int getHighestBitSet() {
        return this.bitSet.previousSetBit(this.bitSet.length() - 1);
    }

    @Override
    @NotNull
    public BitMask cleared() {
        return ZERO;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BitMask)) {
            return false;
        }
        return BitMaskUtil.areEqual(this, (BitMask)object);
    }

    public int hashCode() {
        int n = 0;
        for (long l : this.bitSet.toLongArray()) {
            n ^= BitMaskUtil.getHash64(l);
        }
        return n;
    }

    public String toString() {
        return String.format("<%s>", this.bitSet);
    }
}

