/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.util.BitFlag;
import de.caff.util.BitMask;
import de.caff.util.BitMask16;
import de.caff.util.EnumBitMask;
import de.caff.util.SimpleBitFlag;
import java.util.BitSet;

public class BitMaskUtil {
    private static final long MASK32 = 0xFFFFFFFFL;

    private BitMaskUtil() {
    }

    public static int getHash64(long l) {
        return (int)(l >>> 32 & 0xFFFFFFFFL) ^ (int)(l & 0xFFFFFFFFL);
    }

    public static boolean areEqual(@NotNull BitMask bitMask, @NotNull BitMask bitMask2) {
        int n;
        BitMask bitMask3;
        BitMask bitMask4;
        if (bitMask.getBitCount() >= bitMask2.getBitCount()) {
            bitMask4 = bitMask;
            bitMask3 = bitMask2;
        } else {
            bitMask4 = bitMask2;
            bitMask3 = bitMask;
        }
        for (n = bitMask4.getBitCount() - 1; n >= bitMask3.getBitCount(); --n) {
            if (!bitMask4.isSet(n)) continue;
            return false;
        }
        for (n = bitMask3.getBitCount() - 1; n >= 0; --n) {
            if (bitMask3.isSet(n) == bitMask4.isSet(n)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Enum<T>> boolean areEqual(@NotNull EnumBitMask<T> enumBitMask, @NotNull EnumBitMask<T> enumBitMask2) {
        return BitMaskUtil.areEqual(enumBitMask.getBitMask(), enumBitMask2.getBitMask());
    }

    @NotNull
    public static BitMask toBitMask(@NotNull BitFlag bitFlag) {
        BitMask bitMask = new BitMask(){

            @Override
            public boolean isSet(int n) {
                return false;
            }

            @Override
            public int getBitCount() {
                return 0;
            }

            @Override
            public int getCardinality() {
                return 0;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            @NotNull
            public BitMask set(int n) {
                SimpleBitFlag simpleBitFlag = SimpleBitFlag.get(n);
                return simpleBitFlag.toBitMask();
            }

            @Override
            @NotNull
            public BitMask clear(int n) {
                return BitMask16.ZERO;
            }

            @Override
            @NotNull
            public BitMask flip(int n) {
                return this.set(n);
            }

            @Override
            @NotNull
            public BitMask not() {
                throw new IllegalAccessError("Not implemented!");
            }

            @Override
            @NotNull
            public BitMask and(@NotNull BitMask bitMask) {
                return BitMask16.ZERO;
            }

            @Override
            @NotNull
            public BitMask andNot(@NotNull BitMask bitMask) {
                return BitMask16.ZERO;
            }

            @Override
            @NotNull
            public BitMask or(@NotNull BitMask bitMask) {
                return bitMask;
            }

            @Override
            @NotNull
            public BitMask xor(@NotNull BitMask bitMask) {
                return bitMask;
            }

            @Override
            @NotNull
            public BitSet toBitSet() {
                return new BitSet();
            }

            @Override
            public int low32() {
                return 0;
            }

            @Override
            public long low64() {
                return 0L;
            }

            @Override
            public int getLowestBitSet() {
                return -1;
            }

            @Override
            public int getHighestBitSet() {
                return -1;
            }

            @Override
            @NotNull
            public BitMask cleared() {
                return this;
            }

            public String toString() {
                return "<>";
            }
        };
        return bitFlag.setIn(bitMask);
    }
}

