/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.generics.Primitives;
import de.caff.util.BitMask;
import de.caff.util.BitMaskUtil;
import java.util.BitSet;

public final class BitMask64
implements BitMask {
    public static final int BIT_COUNT = 64;
    public static final BitMask64 ZERO = new BitMask64(0L);
    public static final BitMask64 ALL_SET = new BitMask64(-1L);
    private final long flags;

    public BitMask64(long l) {
        this.flags = l;
    }

    @Override
    public boolean isSet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos needs to be non-negative!");
        }
        if (n >= 64) {
            return false;
        }
        return (this.flags >>> n & 1L) != 0L;
    }

    @Override
    public int getBitCount() {
        return 64;
    }

    @Override
    public int getCardinality() {
        return Long.bitCount(this.flags);
    }

    @Override
    public boolean isEmpty() {
        return this.flags == 0L;
    }

    @Override
    @NotNull
    public BitMask set(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos needs to be non-negative!");
        }
        if (n >= 64 || this.isSet(n)) {
            return this;
        }
        return new BitMask64(this.flags | 1L << n);
    }

    @Override
    @NotNull
    public BitMask clear(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos needs to be non-negative!");
        }
        if (n >= 64 || !this.isSet(n)) {
            return this;
        }
        return new BitMask64(this.flags & (1L << n ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    @NotNull
    public BitMask flip(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos needs to be non-negative!");
        }
        if (n >= 64) {
            return this;
        }
        return new BitMask64(this.flags ^ 1L << n);
    }

    @Override
    @NotNull
    public BitMask not() {
        return new BitMask64(this.flags ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    @NotNull
    public BitMask and(@NotNull BitMask bitMask) {
        if (bitMask.getBitCount() > 64) {
            return bitMask.and(this);
        }
        long l = this.flags & bitMask.low64();
        if (l == this.flags) {
            return this;
        }
        return new BitMask64(l);
    }

    @Override
    @NotNull
    public BitMask andNot(@NotNull BitMask bitMask) {
        if (bitMask.getBitCount() > 64) {
            return bitMask.not().and(this);
        }
        long l = this.flags | bitMask.low64() ^ 0xFFFFFFFFFFFFFFFFL;
        if (l == this.flags) {
            return this;
        }
        return new BitMask64(l);
    }

    @Override
    @NotNull
    public BitMask or(@NotNull BitMask bitMask) {
        if (bitMask.getBitCount() > 64) {
            return bitMask.or(this);
        }
        long l = this.flags | bitMask.low64();
        if (l == this.flags) {
            return this;
        }
        return new BitMask64(l);
    }

    @Override
    @NotNull
    public BitMask xor(@NotNull BitMask bitMask) {
        if (bitMask.getBitCount() > 64) {
            return bitMask.xor(this);
        }
        long l = this.flags ^ bitMask.low64();
        if (l == this.flags) {
            return this;
        }
        return new BitMask64(l);
    }

    @Override
    @NotNull
    public BitSet toBitSet() {
        return BitSet.valueOf(new long[]{this.low64()});
    }

    @Override
    public int low32() {
        return (int)(this.flags & 0xFFFFFFFFL);
    }

    @Override
    public long low64() {
        return this.flags;
    }

    @Override
    public int getLowestBitSet() {
        return Primitives.positionOfLowestOneBit((long)this.flags);
    }

    @Override
    public int getHighestBitSet() {
        return Primitives.positionOfHighestOneBit((long)this.flags);
    }

    @Override
    @NotNull
    public BitMask cleared() {
        return ZERO;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BitMask)) {
            return false;
        }
        return BitMaskUtil.areEqual(this, (BitMask)object);
    }

    public int hashCode() {
        return BitMaskUtil.getHash64(this.low64());
    }

    public String toString() {
        return String.format("<%08x>", this.flags);
    }
}

