/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.generics.Primitives;
import de.caff.util.BitMask;
import de.caff.util.BitMaskUtil;
import java.util.BitSet;

public final class BitMask32
implements BitMask {
    public static final int BIT_COUNT = 32;
    public static final BitMask32 ZERO = new BitMask32(0);
    public static final BitMask32 ALL_SET = new BitMask32(-1);
    private final int flags;

    public BitMask32(int n) {
        this.flags = n;
    }

    @Override
    public boolean isSet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos needs to be non-negative!");
        }
        return n < 32 && (this.flags >>> n & 1) != 0;
    }

    @Override
    public int getBitCount() {
        return 32;
    }

    @Override
    public int getCardinality() {
        return Integer.bitCount(this.flags);
    }

    @Override
    public boolean isEmpty() {
        return this.flags == 0;
    }

    @Override
    @NotNull
    public BitMask set(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos needs to be non-negative!");
        }
        if (this.isSet(n) || n >= 32) {
            return this;
        }
        return new BitMask32(this.flags | 1 << n);
    }

    @Override
    @NotNull
    public BitMask clear(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos needs to be non-negative!");
        }
        if (!this.isSet(n) || n >= 32) {
            return this;
        }
        return new BitMask32(this.flags & ~(1 << n));
    }

    @Override
    @NotNull
    public BitMask flip(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos needs to be non-negative!");
        }
        if (n >= 32) {
            return this;
        }
        return new BitMask32(this.flags ^ ~(1 << n));
    }

    @Override
    @NotNull
    public BitMask not() {
        return new BitMask32(~this.flags);
    }

    @Override
    @NotNull
    public BitMask and(@NotNull BitMask bitMask) {
        if (bitMask.getBitCount() > 32) {
            return bitMask.and(this);
        }
        int n = this.flags & bitMask.low32();
        if (n == this.flags) {
            return this;
        }
        return new BitMask32(n);
    }

    @Override
    @NotNull
    public BitMask andNot(@NotNull BitMask bitMask) {
        if (bitMask.getBitCount() > 32) {
            return bitMask.not().and(this);
        }
        int n = this.flags | ~bitMask.low32();
        if (n == this.flags) {
            return this;
        }
        return new BitMask32(n);
    }

    @Override
    @NotNull
    public BitMask or(@NotNull BitMask bitMask) {
        if (bitMask.getBitCount() > 32) {
            return bitMask.or(this);
        }
        int n = this.flags | bitMask.low32();
        if (n == this.flags) {
            return this;
        }
        return new BitMask32(n);
    }

    @Override
    @NotNull
    public BitMask xor(@NotNull BitMask bitMask) {
        if (bitMask.getBitCount() > 32) {
            return bitMask.xor(this);
        }
        int n = this.flags ^ bitMask.low32();
        if (n == this.flags) {
            return this;
        }
        return new BitMask32(n);
    }

    @Override
    @NotNull
    public BitSet toBitSet() {
        return BitSet.valueOf(new long[]{this.low64()});
    }

    @Override
    public int low32() {
        return this.flags;
    }

    @Override
    public long low64() {
        return this.flags;
    }

    @Override
    public int getLowestBitSet() {
        return Primitives.positionOfLowestOneBit((int)this.flags);
    }

    @Override
    public int getHighestBitSet() {
        return Primitives.positionOfHighestOneBit((int)this.flags);
    }

    @Override
    @NotNull
    public BitMask cleared() {
        return ZERO;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof BitMask)) {
            return false;
        }
        return BitMaskUtil.areEqual(this, (BitMask)object);
    }

    public int hashCode() {
        return BitMaskUtil.getHash64(this.low64());
    }

    public String toString() {
        return String.format("<%04x>", this.flags);
    }
}

