/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.annotation.NotNull;
import de.caff.generics.Primitives;
import de.caff.util.BitMask;
import de.caff.util.BitMaskUtil;
import java.util.BitSet;

public final class BitMask16
implements BitMask {
    public static final int BIT_COUNT = 16;
    public static final BitMask16 ZERO = new BitMask16(0);
    private static final int MASK = 65535;
    public static final BitMask16 ALL_SET = new BitMask16(65535);
    private final short flags;

    public BitMask16(int n) {
        this.flags = (short)(n & 0xFFFF);
    }

    @Override
    public boolean isSet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos needs to be non-negative!");
        }
        return n < 16 && (this.flags >>> n & 1) != 0;
    }

    @Override
    public int getBitCount() {
        return 16;
    }

    @Override
    public int getCardinality() {
        return Integer.bitCount(this.flags & 0xFFFF);
    }

    @Override
    public boolean isEmpty() {
        return (this.flags & 0xFFFF) == 0;
    }

    @Override
    @NotNull
    public BitMask set(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos needs to be non-negative!");
        }
        if (this.isSet(n) || n >= 16) {
            return this;
        }
        return new BitMask16(this.flags | 1 << n);
    }

    @Override
    @NotNull
    public BitMask clear(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos needs to be non-negative!");
        }
        if (!this.isSet(n) || n >= 16) {
            return this;
        }
        return new BitMask16(this.flags & ~(1 << n));
    }

    @Override
    @NotNull
    public BitMask flip(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("pos needs to be non-negative!");
        }
        if (n >= 16) {
            return this;
        }
        return new BitMask16(this.flags ^ ~(1 << n));
    }

    @Override
    @NotNull
    public BitMask not() {
        return new BitMask16(~this.flags);
    }

    @Override
    @NotNull
    public BitMask and(@NotNull BitMask bitMask) {
        if (bitMask.getBitCount() > 16) {
            return bitMask.and(this);
        }
        int n = this.flags & bitMask.low32();
        if (n == this.flags) {
            return this;
        }
        return new BitMask16(n);
    }

    @Override
    @NotNull
    public BitMask andNot(@NotNull BitMask bitMask) {
        if (bitMask.getBitCount() > 16) {
            return bitMask.not().and(this);
        }
        int n = this.flags | ~bitMask.low32();
        if (n == this.flags) {
            return this;
        }
        return new BitMask16(n);
    }

    @Override
    @NotNull
    public BitMask or(@NotNull BitMask bitMask) {
        if (bitMask.getBitCount() > 16) {
            return bitMask.or(this);
        }
        int n = this.flags | bitMask.low32();
        if (n == this.flags) {
            return this;
        }
        return new BitMask16(n);
    }

    @Override
    @NotNull
    public BitMask xor(@NotNull BitMask bitMask) {
        if (bitMask.getBitCount() > 16) {
            return bitMask.xor(this);
        }
        int n = this.flags ^ bitMask.low32();
        if (n == this.flags) {
            return this;
        }
        return new BitMask16(n);
    }

    @Override
    @NotNull
    public BitSet toBitSet() {
        return BitSet.valueOf(new long[]{this.low64()});
    }

    @Override
    public int low32() {
        return this.flags & 0xFFFF;
    }

    @Override
    public long low64() {
        return this.flags & 0xFFFF;
    }

    @Override
    public int getLowestBitSet() {
        return this.flags < 0 ? 15 : Primitives.positionOfLowestOneBit((int)this.flags);
    }

    @Override
    public int getHighestBitSet() {
        return Primitives.positionOfHighestOneBit((int)this.flags);
    }

    @Override
    @NotNull
    public BitMask cleared() {
        return ZERO;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BitMask)) {
            return false;
        }
        return BitMaskUtil.areEqual(this, (BitMask)object);
    }

    public int hashCode() {
        return BitMaskUtil.getHash64(this.low64());
    }

    public String toString() {
        return String.format("<%02x>", this.flags);
    }
}

