/*
 * Decompiled with CFR 0.152.
 */
package de.caff.io.xml;

import de.caff.annotation.NotNull;
import de.caff.io.xml.SimpleXmlWriter;
import de.caff.io.xml.XmlStorable;
import de.caff.io.xml.XmlTool;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public interface XmlDispatchedStorable
extends XmlStorable {
    @NotNull
    public static final String XML_ATTR_READ_METHOD = "reader";

    default public void storeOuterXml(@NotNull SimpleXmlWriter simpleXmlWriter, @NotNull String string) {
        simpleXmlWriter.begin(string, "version", 1, XML_ATTR_READ_METHOD, this.getXmlReaderMethod());
        this.storeInnerXml(simpleXmlWriter);
        simpleXmlWriter.end(string);
    }

    public void storeInnerXml(@NotNull SimpleXmlWriter var1);

    @NotNull
    public String getXmlReaderMethod();

    @NotNull
    public static <T> T fromXmlElement(@NotNull Element element, @NotNull String string, @NotNull Class<T> clazz) throws SAXException {
        XmlTool.checkTagAndVersion(element, string, 1);
        Element element2 = XmlTool.getSingleChild(element);
        String string2 = XmlTool.getValue(element, XML_ATTR_READ_METHOD);
        String[] stringArray = string2.split(Pattern.quote("#"));
        if (stringArray.length != 2) {
            throw new SAXException(String.format("Expecting argument in the form full.class.name#methodName, but got %s!", string2));
        }
        try {
            Class<?> clazz2 = Class.forName(stringArray[0]);
            Method method = clazz2.getDeclaredMethod(stringArray[1], Element.class);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new SAXException(String.format("Expecting a method %s to be static!", string2));
            }
            Object object = method.invoke(null, element2);
            try {
                return clazz.cast(Objects.requireNonNull(object));
            }
            catch (ClassCastException classCastException) {
                throw new SAXException(String.format("Recreate object is of type %s, but required type is %s!", object.getClass().getName(), clazz.getName()));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXException(String.format("Could not find class %s necessary to recreate parametric curve!", stringArray[0]), classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SAXException(String.format("Could not find method %s.%s(Element)!", stringArray[0], stringArray[1]), noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SAXException) {
                throw (SAXException)throwable;
            }
            if (throwable instanceof Exception) {
                throw new SAXException(String.format("Parametric curve recreation by %s failed with unexpected exception!", string2), (Exception)throwable);
            }
            throw new SAXException(String.format("Parametric curve recreation by %s failed with unexpected exception!", string2), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException(String.format("Cannot access reader method %s for recreating parametric curve!", string2), illegalAccessException);
        }
    }
}

