/*
 * Decompiled with CFR 0.152.
 */
package de.caff.io.xml;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Countable;
import de.caff.generics.Indexable;
import de.caff.generics.Pair;
import de.caff.generics.Types;
import de.caff.io.StringCollector;
import de.caff.io.xml.XmlStorable;
import de.caff.util.Base64;
import de.caff.util.StringHelper;
import java.util.Collection;
import java.util.Locale;
import java.util.Stack;

public class SimpleXmlWriter
implements AutoCloseable {
    public static final String DEFAULT_ENCODING = "utf-8";
    private static final String[] HEX = new String[256];
    @NotNull
    private final Stack<String> openElements = new Stack();
    @NotNull
    protected final StringCollector collector;
    protected final boolean autoWrap;
    @Nullable
    protected final String indentation;
    @NotNull
    protected final Locale locale;

    public SimpleXmlWriter(@NotNull StringCollector stringCollector) {
        this(stringCollector, -1);
    }

    public SimpleXmlWriter(@NotNull Locale locale, @NotNull StringCollector stringCollector) {
        this(locale, stringCollector, -1);
    }

    public SimpleXmlWriter(@NotNull StringCollector stringCollector, @Nullable String string) {
        this(stringCollector, string, -1);
    }

    public SimpleXmlWriter(@NotNull Locale locale, @NotNull StringCollector stringCollector, @Nullable String string) {
        this(locale, stringCollector, string, -1);
    }

    public SimpleXmlWriter(@NotNull StringCollector stringCollector, int n) {
        this(stringCollector, SimpleXmlWriter.getDefaultPreamble(), n);
    }

    public SimpleXmlWriter(@NotNull Locale locale, @NotNull StringCollector stringCollector, int n) {
        this(locale, stringCollector, SimpleXmlWriter.getDefaultPreamble(), n);
    }

    public SimpleXmlWriter(@NotNull StringCollector stringCollector, @Nullable String string, int n) {
        this(Locale.getDefault(), stringCollector, string, n);
    }

    public SimpleXmlWriter(@NotNull Locale locale, @NotNull StringCollector stringCollector, @Nullable String string, int n) {
        this.collector = stringCollector;
        this.locale = locale;
        this.autoWrap = n >= 0;
        String string2 = this.indentation = n > 0 ? Types.spaces((int)n) : null;
        if (string != null) {
            this.add(string);
        }
    }

    public boolean isAutoWrap() {
        return this.autoWrap;
    }

    @NotNull
    public String getIndentation() {
        return Types.notNull((String)this.indentation);
    }

    @NotNull
    public Locale getLocale() {
        return this.locale;
    }

    @NotNull
    public static String getDefaultPreamble() {
        return SimpleXmlWriter.getPreamble(DEFAULT_ENCODING);
    }

    @NotNull
    public static String getPreamble(@NotNull String string) {
        return String.format("<?xml version=\"1.0\" encoding=\"%s\"?>", string);
    }

    private void insertAutoWrap(int n) {
        if (!this.autoWrap) {
            return;
        }
        switch (this.collector.getLastLetter()) {
            case '>': {
                this.nl();
            }
            case '\n': {
                if (n <= 0 || this.indentation == null) break;
                for (int i = 0; i < n; ++i) {
                    this.add(this.indentation);
                }
                break;
            }
        }
    }

    @NotNull
    public SimpleXmlWriter begin(@NotNull String string, Object ... objectArray) {
        this.openElements.push(string);
        return this.writeElement(true, string, Indexable.viewArray((Object[])objectArray));
    }

    @NotNull
    public SimpleXmlWriter beginI(@NotNull String string, @NotNull Indexable<?> indexable) {
        this.openElements.push(string);
        return this.writeElement(true, string, indexable);
    }

    @NotNull
    public SimpleXmlWriter beginP(@NotNull String string, @NotNull Indexable<? extends Pair<?>> indexable) {
        this.openElements.push(string);
        return this.writeElement(true, string, SimpleXmlWriter.unpaired(indexable));
    }

    @NotNull
    private static Indexable<?> unpaired(@NotNull Indexable<? extends Pair<?>> indexable) {
        return Indexable.viewByIndex((int)(2 * indexable.size()), n -> n % 2 == 0 ? ((Pair)indexable.get((int)(n / 2))).first : ((Pair)indexable.get((int)(n / 2))).second);
    }

    @NotNull
    public SimpleXmlWriter end() {
        return this.end(null);
    }

    @NotNull
    public SimpleXmlWriter end(@Nullable String string) {
        this.insertAutoWrap(this.openElements.size() - 1);
        String string2 = this.openElements.pop();
        if (string != null && !string2.equals(string)) {
            throw new IllegalStateException(String.format("Expected to close tag <%s>, but currently open tag is <%s>!", string, string2));
        }
        this.add("</").quote(string2).add(">");
        return this;
    }

    @NotNull
    public SimpleXmlWriter comment(@NotNull String string) {
        this.insertAutoWrap(this.openElements.size());
        this.add("<!-- ").add(string).add("-->");
        return this;
    }

    @NotNull
    public SimpleXmlWriter expand(@NotNull byte[] byArray) {
        for (byte by : byArray) {
            this.add(HEX[by & 0xFF]);
        }
        return this;
    }

    @NotNull
    public static String expand(@NotNull byte[] byArray, int n) {
        StringBuilder stringBuilder;
        if (n > 0) {
            stringBuilder = new StringBuilder(2 * byArray.length + byArray.length / n);
            for (int i = 0; i < byArray.length; ++i) {
                if (i % n == 0 && i > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(HEX[byArray[i] & 0xFF]);
            }
        } else {
            stringBuilder = new StringBuilder(2 * byArray.length);
            for (byte by : byArray) {
                stringBuilder.append(HEX[by & 0xFF]);
            }
        }
        return stringBuilder.toString();
    }

    @NotNull
    public SimpleXmlWriter expandBase64(@NotNull byte[] byArray) {
        this.add(Base64.encodeBytes(byArray));
        return this;
    }

    @NotNull
    public SimpleXmlWriter element(@NotNull String string, Object ... objectArray) {
        this.writeElement(false, string, Indexable.viewArray((Object[])objectArray));
        return this;
    }

    @NotNull
    public SimpleXmlWriter elementI(@NotNull String string, @NotNull Indexable<?> indexable) {
        this.writeElement(false, string, indexable);
        return this;
    }

    @NotNull
    public SimpleXmlWriter elementP(@NotNull String string, @NotNull Indexable<? extends Pair<?>> indexable) {
        this.writeElement(false, string, SimpleXmlWriter.unpaired(indexable));
        return this;
    }

    @NotNull
    public SimpleXmlWriter text(@NotNull Object object) {
        return this.quote(object);
    }

    @NotNull
    public SimpleXmlWriter indentedText(@NotNull Object object) {
        String string = object.toString().trim();
        if (this.indentation == null) {
            return this.quote(string);
        }
        for (String string2 : StringHelper.EOL_PATTERN.split(string)) {
            this.insertAutoWrap(this.openElements.size());
            this.quote(string2.trim());
            this.nl();
        }
        return this;
    }

    @NotNull
    public SimpleXmlWriter textf(@NotNull String string, Object ... objectArray) {
        return this.text(String.format(this.locale, string, objectArray));
    }

    @NotNull
    public SimpleXmlWriter indentedText(@NotNull String string, Object ... objectArray) {
        return this.indentedText(String.format(this.locale, string, objectArray));
    }

    @NotNull
    public SimpleXmlWriter nl() {
        return this.add("\n");
    }

    @NotNull
    public SimpleXmlWriter cdata(@NotNull String string) {
        return this.add("<![CDATA[" + SimpleXmlWriter.quoteCData(string) + "]]>");
    }

    @NotNull
    private static String quoteCData(@NotNull String string) {
        return string.replace("]]>", "]]&#62;");
    }

    @NotNull
    private SimpleXmlWriter writeElement(boolean bl, @NotNull String string, @NotNull Indexable<?> indexable) {
        int n = indexable.size();
        if (n % 2 == 1) {
            throw new IllegalArgumentException("Need an even number of attributes");
        }
        this.insertAutoWrap(bl ? this.openElements.size() - 1 : this.openElements.size());
        this.add("<").quote(string);
        for (int i = 0; i < n; i += 2) {
            this.add(" ").quote(indexable.get(i)).add("=\"").quote(indexable.get(i + 1)).add("\"");
        }
        return this.add(bl ? ">" : "/>");
    }

    @NotNull
    private SimpleXmlWriter add(@NotNull String string) {
        this.collector.add(string);
        return this;
    }

    @NotNull
    private SimpleXmlWriter quote(@Nullable Object object) {
        if (object == null) {
            return this.add("null");
        }
        String string = object.toString();
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this.collector.add("&lt;");
                    continue block7;
                }
                case '>': {
                    this.collector.add("&gt;");
                    continue block7;
                }
                case '\"': {
                    this.collector.add("&quot;");
                    continue block7;
                }
                case '&': {
                    this.collector.add("&amp;");
                    continue block7;
                }
                case '\'': {
                    this.collector.add("&apos;");
                    continue block7;
                }
                default: {
                    this.collector.add(c);
                }
            }
        }
        return this;
    }

    @Override
    public void close() {
        while (!this.openElements.isEmpty()) {
            this.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SimpleXmlWriter loop(@NotNull String string, @NotNull Iterable<? extends XmlStorable> iterable) {
        try {
            this.begin(string, new Object[0]);
            for (XmlStorable xmlStorable : iterable) {
                xmlStorable.storeXml(this);
            }
        }
        finally {
            this.end(string);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SimpleXmlWriter loop(@NotNull String string, @NotNull String string2, @NotNull Countable<? extends XmlStorable> countable) {
        try {
            this.begin(string, string2, countable.size());
            for (XmlStorable xmlStorable : countable) {
                xmlStorable.storeXml(this);
            }
        }
        finally {
            this.end(string);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SimpleXmlWriter loop(@NotNull String string, @NotNull String string2, @NotNull Collection<? extends XmlStorable> collection) {
        try {
            this.begin(string, string2, collection.size());
            for (XmlStorable xmlStorable : collection) {
                xmlStorable.storeXml(this);
            }
        }
        finally {
            this.end(string);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SimpleXmlWriter loop(@NotNull String string, @NotNull String string2, XmlStorable ... xmlStorableArray) {
        try {
            this.begin(string, string2, xmlStorableArray.length);
            for (XmlStorable xmlStorable : xmlStorableArray) {
                xmlStorable.storeXml(this);
            }
        }
        finally {
            this.end(string);
        }
        return this;
    }

    static {
        for (int i = 255; i >= 0; --i) {
            SimpleXmlWriter.HEX[i] = String.format("%02X", i);
        }
    }
}

