/*
 * Decompiled with CFR 0.152.
 */
package de.caff.io.json;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.PrimitiveBooleanIterable;
import de.caff.generics.PrimitiveBooleanIterator;
import de.caff.generics.PrimitiveDoubleIterable;
import de.caff.generics.PrimitiveIntIterable;
import de.caff.generics.Types;
import de.caff.io.OutputStreamStringCollector;
import de.caff.io.StringCollector;
import de.caff.io.json.Json;
import java.io.Closeable;
import java.io.IOException;
import java.util.Stack;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;

public class SimpleJsonWriter
implements Closeable {
    @NotNull
    private final Stack<Json.Env> openItems = new Stack();
    @NotNull
    private final StringCollector stringCollector;
    @Nullable
    private final String basicIndent;
    @NotNull
    private String indentation;
    private final boolean prettify;
    private State state;

    public SimpleJsonWriter(@NotNull StringCollector stringCollector) {
        this(stringCollector, 0);
    }

    public SimpleJsonWriter(@NotNull StringCollector stringCollector, int n) {
        this(stringCollector, n, false);
    }

    public SimpleJsonWriter(@NotNull StringCollector stringCollector, int n, boolean bl) {
        this.stringCollector = stringCollector;
        this.basicIndent = n > 0 ? Types.multiple((String)" ", (int)n) : null;
        this.indentation = "";
        this.prettify = n >= 0;
        this.state = bl ? State.Relaxed : State.FirstValue;
    }

    private void nextItem() {
        if (this.state.needsSeparator(this.openItems)) {
            this.stringCollector.add(',');
            if (this.prettify) {
                this.stringCollector.add('\n');
                if (this.basicIndent != null) {
                    this.stringCollector.add(this.indentation);
                }
            }
        }
    }

    @NotNull
    public SimpleJsonWriter key(@NotNull String string) {
        if (!this.state.allowsKey) {
            throw new IllegalStateException("Key is not allowed in state " + (Object)((Object)this.state));
        }
        this.nextItem();
        this.stringCollector.add("\"" + Json.maskForOutput(string) + "\":");
        if (this.prettify) {
            this.stringCollector.add(' ');
        }
        this.state = State.FirstValue;
        return this;
    }

    private SimpleJsonWriter writeRawValue(@NotNull String string) {
        if (!this.state.allowsValue) {
            throw new IllegalStateException("Value is not allowed in state " + (Object)((Object)this.state));
        }
        this.nextItem();
        this.stringCollector.add(string);
        this.state = this.state.advance(this.openItems);
        return this;
    }

    @NotNull
    public SimpleJsonWriter value(@Nullable String string) {
        return string != null ? this.writeRawValue("\"" + Json.maskForOutput(string) + "\"") : this.nul();
    }

    @NotNull
    public SimpleJsonWriter value(int n) {
        return this.writeRawValue(Integer.toString(n));
    }

    @NotNull
    public SimpleJsonWriter value(double d) {
        return this.writeRawValue(Double.toString(d));
    }

    @NotNull
    public SimpleJsonWriter value(boolean bl) {
        return this.writeRawValue(bl ? "true" : "false");
    }

    @NotNull
    public SimpleJsonWriter nul() {
        return this.writeRawValue("null");
    }

    private void beginGrouping(char c) {
        this.stringCollector.add(c);
        if (this.prettify) {
            this.stringCollector.add('\n');
            if (this.basicIndent != null) {
                this.indentation = this.indentation + this.basicIndent;
                this.stringCollector.add(this.indentation);
            }
        }
    }

    private void endGrouping(char c) {
        if (this.prettify) {
            this.stringCollector.add('\n');
            if (this.basicIndent != null) {
                this.indentation = this.indentation.substring(this.basicIndent.length());
                this.stringCollector.add(this.indentation);
            }
        }
        this.stringCollector.add(c);
    }

    @NotNull
    public SimpleJsonWriter beginObject() {
        if (!this.state.allowsValue) {
            throw new IllegalStateException("Object is not allowed in state " + (Object)((Object)this.state));
        }
        this.nextItem();
        this.openItems.push(Json.Env.Object);
        this.state = State.FirstKey;
        this.beginGrouping('{');
        return this;
    }

    @NotNull
    public SimpleJsonWriter endObject() {
        if (this.openItems.isEmpty()) {
            throw new IllegalStateException("Cannot end object, none is open!");
        }
        Json.Env env = this.openItems.pop();
        if (env != Json.Env.Object) {
            throw new IllegalStateException("Cannot end object, open is " + (Object)((Object)env) + ".");
        }
        this.state = this.openItems.isEmpty() ? State.None : this.openItems.peek().defaultState;
        this.endGrouping('}');
        return this;
    }

    @NotNull
    public SimpleJsonWriter beginArray() {
        if (!this.state.allowsValue) {
            throw new IllegalStateException("Cannot start array in state " + (Object)((Object)this.state) + "!");
        }
        this.nextItem();
        this.openItems.push(Json.Env.Array);
        this.state = State.FirstValue;
        this.beginGrouping('[');
        return this;
    }

    @NotNull
    public SimpleJsonWriter endArray() {
        if (this.openItems.isEmpty()) {
            throw new IllegalStateException("Cannot end array, none is open!");
        }
        Json.Env env = this.openItems.pop();
        if (env != Json.Env.Array) {
            throw new IllegalStateException("Cannot end object, open is " + (Object)((Object)env) + ".");
        }
        this.state = this.openItems.isEmpty() ? State.None : this.openItems.peek().defaultState;
        this.endGrouping(']');
        return this;
    }

    @NotNull
    public SimpleJsonWriter array(String ... stringArray) {
        return this.array((Iterable<String>)Indexable.viewArray((Object[])stringArray));
    }

    @NotNull
    public SimpleJsonWriter array(@NotNull Iterable<String> iterable) {
        this.beginArray();
        iterable.forEach(this::value);
        this.endArray();
        return this;
    }

    @NotNull
    public <T> SimpleJsonWriter stringArray(@NotNull Iterable<T> iterable, @NotNull Function<? super T, String> function) {
        return this.array(Types.view(iterable, function));
    }

    @NotNull
    public SimpleJsonWriter array(int ... nArray) {
        return this.array((PrimitiveIntIterable)IntIndexable.viewArray((int[])nArray));
    }

    @NotNull
    public SimpleJsonWriter array(@NotNull PrimitiveIntIterable primitiveIntIterable) {
        this.beginArray();
        primitiveIntIterable.forEachInt(this::value);
        this.endArray();
        return this;
    }

    @NotNull
    public SimpleJsonWriter intArray(@NotNull Iterable<? extends Number> iterable) {
        return this.intArray(iterable, Number::intValue);
    }

    @NotNull
    public <T> SimpleJsonWriter intArray(@NotNull Iterable<T> iterable, @NotNull ToIntFunction<? super T> toIntFunction) {
        return this.array(Types.intView(iterable, toIntFunction));
    }

    @NotNull
    public SimpleJsonWriter array(double ... dArray) {
        return this.array((PrimitiveDoubleIterable)DoubleIndexable.viewArray((double[])dArray));
    }

    @NotNull
    public SimpleJsonWriter array(@NotNull PrimitiveDoubleIterable primitiveDoubleIterable) {
        this.beginArray();
        primitiveDoubleIterable.forEachDouble(this::value);
        this.endArray();
        return this;
    }

    @NotNull
    public SimpleJsonWriter doubleArray(@NotNull Iterable<? extends Number> iterable) {
        return this.doubleArray(iterable, Number::doubleValue);
    }

    @NotNull
    public <T> SimpleJsonWriter doubleArray(@NotNull Iterable<T> iterable, @NotNull ToDoubleFunction<? super T> toDoubleFunction) {
        return this.array(Types.doubleView(iterable, toDoubleFunction));
    }

    @NotNull
    public SimpleJsonWriter array(boolean ... blArray) {
        return this.array((PrimitiveBooleanIterable)BooleanIndexable.viewArray((boolean[])blArray));
    }

    @NotNull
    public SimpleJsonWriter array(@NotNull PrimitiveBooleanIterable primitiveBooleanIterable) {
        this.beginArray();
        PrimitiveBooleanIterator primitiveBooleanIterator = primitiveBooleanIterable.booleanIterator();
        while (primitiveBooleanIterator.hasNext()) {
            this.value(primitiveBooleanIterator.nextBool());
        }
        this.endArray();
        return this;
    }

    @NotNull
    public <T> SimpleJsonWriter booleanArray(@NotNull Iterable<T> iterable, @NotNull Predicate<? super T> predicate) {
        return this.array(Types.booleanView(iterable, predicate));
    }

    @Override
    public void close() {
        if (this.prettify) {
            this.stringCollector.add('\n');
        }
        while (!this.openItems.isEmpty()) {
            this.openItems.pop().close(this);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        OutputStreamStringCollector outputStreamStringCollector = new OutputStreamStringCollector(System.out);
        try (SimpleJsonWriter simpleJsonWriter = new SimpleJsonWriter(outputStreamStringCollector, 2);){
            simpleJsonWriter.beginObject();
            simpleJsonWriter.key("name").value("Henrik Nielsen").key("size").value(1.84).key("age").value(42);
            simpleJsonWriter.key("address").beginObject().key("street").value("Kastanievej 15, 2, Agerskov").key("city").value("SKANDERB\u00d8RG").key("zipcode").value(8660).key("country").value("DENMARK").endObject();
            simpleJsonWriter.key("foods").beginArray().value("Pizza").value("Bami Goreng").value("Ginger Icecream").endArray();
            simpleJsonWriter.key("payments").beginArray().array("22.74\u20ac", "199.21\u20ac", "0.95\u20ac").array("42.00\u20ac", "1234.56\u20ac").endArray();
            simpleJsonWriter.endObject();
        }
        System.out.println("\n======================================\n");
        simpleJsonWriter = new SimpleJsonWriter(outputStreamStringCollector, 2, true);
        var3_3 = null;
        try {
            simpleJsonWriter.key("test").beginObject();
            simpleJsonWriter.key("name").value("Henrik Nielsen").key("size").value(1.84).key("age").value(42);
            simpleJsonWriter.key("address").beginObject().key("street").value("Kastanievej 15, 2, Agerskov").key("city").value("SKANDERB\u00d8RG").key("zipcode").value(8660).key("country").value("DENMARK").endObject();
            simpleJsonWriter.key("foods").beginArray().value("Pizza").value("Bami Goreng").value("Ginger Icecream").endArray();
            simpleJsonWriter.endObject();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (simpleJsonWriter != null) {
                if (var3_3 != null) {
                    try {
                        simpleJsonWriter.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    simpleJsonWriter.close();
                }
            }
        }
    }

    static enum State {
        Relaxed(true, true){

            @Override
            @NotNull
            State advance(@NotNull Stack<Json.Env> stack) {
                return None;
            }

            @Override
            boolean needsSeparator(@NotNull Stack<Json.Env> stack) {
                return false;
            }
        }
        ,
        None(false, false){

            @Override
            @NotNull
            State advance(@NotNull Stack<Json.Env> stack) {
                return None;
            }

            @Override
            boolean needsSeparator(@NotNull Stack<Json.Env> stack) {
                return false;
            }
        }
        ,
        FirstValue(false, true){

            @Override
            @NotNull
            State advance(@NotNull Stack<Json.Env> stack) {
                return stack.isEmpty() ? None : stack.peek().defaultState;
            }

            @Override
            boolean needsSeparator(@NotNull Stack<Json.Env> stack) {
                return false;
            }
        }
        ,
        Value(false, true){

            @Override
            @NotNull
            State advance(@NotNull Stack<Json.Env> stack) {
                return stack.peek() == Json.Env.Object ? Key : Value;
            }

            @Override
            boolean needsSeparator(@NotNull Stack<Json.Env> stack) {
                return !stack.isEmpty() && stack.peek() == Json.Env.Array;
            }
        }
        ,
        FirstKey(true, false){

            @Override
            @NotNull
            State advance(@NotNull Stack<Json.Env> stack) {
                return Key;
            }

            @Override
            boolean needsSeparator(@NotNull Stack<Json.Env> stack) {
                return false;
            }
        }
        ,
        Key(true, false){

            @Override
            @NotNull
            State advance(@NotNull Stack<Json.Env> stack) {
                return Key;
            }

            @Override
            boolean needsSeparator(@NotNull Stack<Json.Env> stack) {
                return true;
            }
        };

        final boolean allowsKey;
        final boolean allowsValue;

        private State(boolean bl, boolean bl2) {
            this.allowsKey = bl;
            this.allowsValue = bl2;
        }

        @NotNull
        abstract State advance(@NotNull Stack<Json.Env> var1);

        abstract boolean needsSeparator(@NotNull Stack<Json.Env> var1);
    }
}

