/*
 * Decompiled with CFR 0.152.
 */
package de.caff.io.json;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.OrderedPair;
import de.caff.generics.function.BooleanConsumer;
import de.caff.io.StringCollector;
import de.caff.io.TextStringCollector;
import de.caff.io.json.Json;
import de.caff.io.json.SimpleJsonWriter;
import de.caff.util.Utility;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;

public class SimpleJsonReader {
    private static final boolean DEBUG_TOKENS = Utility.getBooleanParameter("json.tokens.dump", false);
    @NotNull
    private final Tokenizer tokenizer;
    @NotNull
    private final Stack<Handler> handlerStack = new Stack();
    @NotNull
    private final Stack<OrderedPair<Json.Env, Integer>> environmentStack = new Stack();
    public static final TemporaryHandler SKIP_HANDLER = new TemporaryHandler(){

        @Override
        public void initialize(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void finish(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void key(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
        }

        @Override
        public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void nullValue(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, boolean bl) {
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull Number number) {
        }
    };

    private SimpleJsonReader(@NotNull Reader reader, @NotNull Handler handler) {
        this.tokenizer = new Tokenizer(reader);
        this.handlerStack.push(handler);
    }

    public void pushSubHandler(@NotNull Handler handler) {
        this.handlerStack.push(handler);
    }

    @NotNull
    public Handler popSubHandler() {
        if (this.handlerStack.size() <= 1) {
            throw new IllegalStateException("Popping too often!");
        }
        return this.handlerStack.pop();
    }

    @NotNull
    public Handler getSubHandler() {
        if (this.handlerStack.isEmpty()) {
            throw new IllegalStateException("No subhandler available!");
        }
        return this.handlerStack.peek();
    }

    @Nullable
    public Json.Env getEnvironment() {
        return this.environmentStack.isEmpty() ? null : (Json.Env)((Object)this.environmentStack.peek().first);
    }

    private void read() throws IOException {
        Object object;
        Token token;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        block14: while ((token = this.tokenizer.nextToken()) != null) {
            if (DEBUG_TOKENS) {
                System.out.println(token);
            }
            switch (token.type) {
                case Colon: {
                    throw new IOException("Unexpected colon in line " + this.tokenizer.getLineNumber());
                }
                case Comma: {
                    if (bl3) {
                        bl2 = this.environmentStack.peek().first == Json.Env.Array;
                        bl = !bl2;
                        bl4 = false;
                        bl3 = false;
                        continue block14;
                    }
                    throw new IOException("Unexpected comma in line " + this.tokenizer.getLineNumber());
                }
                case OpenBrace: {
                    if (!bl2) {
                        throw new IOException("Unexpected start of object ('{') in line " + this.tokenizer.getLineNumber());
                    }
                    bl4 = true;
                    bl = true;
                    bl3 = false;
                    bl2 = false;
                    this.handlerStack.peek().beginObject(this);
                    this.environmentStack.push((OrderedPair<Json.Env, Integer>)OrderedPair.create((Object)((Object)Json.Env.Object), (Object)this.tokenizer.getLineNumber()));
                    continue block14;
                }
                case CloseBrace: {
                    if (!bl4 || this.environmentStack.isEmpty() || this.environmentStack.pop().first != Json.Env.Object) {
                        throw new IOException("Unexpected end of object ('}') in line " + this.tokenizer.getLineNumber());
                    }
                    bl2 = false;
                    bl = false;
                    bl4 = true;
                    bl3 = true;
                    this.handlerStack.peek().endObject(this);
                    continue block14;
                }
                case OpenBracket: {
                    if (!bl2) {
                        throw new IOException("Unexpected start of array ('[') in line " + this.tokenizer.getLineNumber());
                    }
                    bl3 = false;
                    bl = false;
                    bl2 = true;
                    bl4 = true;
                    this.handlerStack.peek().beginArray(this);
                    this.environmentStack.push((OrderedPair<Json.Env, Integer>)OrderedPair.create((Object)((Object)Json.Env.Array), (Object)this.tokenizer.getLineNumber()));
                    continue block14;
                }
                case CloseBracket: {
                    if (!bl4 || this.environmentStack.isEmpty() || this.environmentStack.pop().first != Json.Env.Array) {
                        throw new IOException("Unexpected end of array ('}') in line " + this.tokenizer.getLineNumber());
                    }
                    bl2 = false;
                    bl = false;
                    bl3 = true;
                    bl4 = true;
                    this.handlerStack.peek().endArray(this);
                    continue block14;
                }
                case NullValue: {
                    if (!bl2) {
                        throw new IOException(String.format("Unexpected token %s in line %d!", token, this.tokenizer.getLineNumber()));
                    }
                    this.handlerStack.peek().nullValue(this);
                    break;
                }
                case TrueValue: {
                    if (!bl2) {
                        throw new IOException(String.format("Unexpected token %s in line %d!", token, this.tokenizer.getLineNumber()));
                    }
                    this.handlerStack.peek().value(this, true);
                    break;
                }
                case FalseValue: {
                    if (!bl2) {
                        throw new IOException(String.format("Unexpected token %s in line %d!", token, this.tokenizer.getLineNumber()));
                    }
                    this.handlerStack.peek().value(this, false);
                    break;
                }
                case IntegerValue: {
                    if (!bl2) {
                        throw new IOException(String.format("Unexpected token %s in line %d!", token, this.tokenizer.getLineNumber()));
                    }
                    this.handlerStack.peek().value(this, (Integer)token.value);
                    break;
                }
                case DoubleValue: {
                    if (!bl2) {
                        throw new IOException(String.format("Unexpected token %s in line %d!", token, this.tokenizer.getLineNumber()));
                    }
                    this.handlerStack.peek().value(this, (Double)token.value);
                    break;
                }
                case StringValue: {
                    if (bl) {
                        object = this.tokenizer.nextToken();
                        if (object == null || ((Token)object).type != Token.Type.Colon) {
                            throw new IOException(String.format("Expected a key with a colon in line %d, but got %s!", this.tokenizer.getLineNumber(), object));
                        }
                        bl2 = true;
                        bl4 = false;
                        bl3 = false;
                        bl = false;
                        this.handlerStack.peek().key(this, (String)token.value);
                        continue block14;
                    }
                    if (!bl2) {
                        throw new IOException(String.format("Unexpected token %s in line %d!", token, this.tokenizer.getLineNumber()));
                    }
                    this.handlerStack.peek().value(this, (String)token.value);
                }
            }
            bl = false;
            bl2 = false;
            bl3 = true;
            bl4 = true;
        }
        if (!this.environmentStack.isEmpty()) {
            object = this.environmentStack.peek();
            throw new IOException(String.format("Unclosed %s environment started in line %d at EOF!", object.first, object.second));
        }
    }

    public static void read(@NotNull Reader reader, @NotNull Handler handler) throws IOException {
        new SimpleJsonReader(reader, handler).read();
    }

    public static void read(@NotNull InputStream inputStream, @NotNull Charset charset, @NotNull Handler handler) throws IOException {
        SimpleJsonReader.read(new InputStreamReader(inputStream, charset), handler);
    }

    public static void read(@NotNull InputStream inputStream, @NotNull Handler handler) throws IOException {
        SimpleJsonReader.read(inputStream, StandardCharsets.UTF_8, handler);
    }

    @NotNull
    public static Map<String, Object> readToMap(@NotNull Reader reader) throws IOException {
        final MapObjectHandler mapObjectHandler = new MapObjectHandler();
        SimpleJsonReader.read(reader, (Handler)new ValueHandler(){

            @Override
            @NotNull
            protected TemporaryHandler object() {
                return mapObjectHandler;
            }
        });
        return mapObjectHandler.getMap();
    }

    @NotNull
    public static Map<String, Object> readToMap(@NotNull InputStream inputStream, @NotNull Charset charset) throws IOException {
        return SimpleJsonReader.readToMap(new InputStreamReader(inputStream, charset));
    }

    @NotNull
    public static Map<String, Object> readToMap(@NotNull InputStream inputStream) throws IOException {
        return SimpleJsonReader.readToMap(inputStream, StandardCharsets.UTF_8);
    }

    public static void main(@NotNull String[] stringArray) throws IOException {
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                System.out.println(SimpleJsonReader.readToMap(new FileReader(string)));
            }
            return;
        }
        TextStringCollector textStringCollector = new TextStringCollector();
        Object object = new SimpleJsonWriter(textStringCollector, 2);
        Object object2 = null;
        try {
            ((SimpleJsonWriter)object).beginObject();
            ((SimpleJsonWriter)object).key("name").value("Henrik Nielsen").key("size").value(1.84).key("age").value(42).key("clever").value(true);
            ((SimpleJsonWriter)object).key("address").beginObject().key("street").value("Kastanievej 15, 2, Agerskov").key("city").value("SKANDERB\u00d8RG").key("zipcode").value(8660).key("country").value("DENMARK").endObject();
            ((SimpleJsonWriter)object).key("foods").beginArray().value("Pizza").value("Bami Goreng").value("Ginger Icecream").endArray();
            ((SimpleJsonWriter)object).endObject();
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((SimpleJsonWriter)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((SimpleJsonWriter)object).close();
                }
            }
        }
        object = textStringCollector.getText();
        object2 = new TextStringCollector();
        Object object3 = null;
        try (Object object4 = new SimpleJsonWriter((StringCollector)object2, 2);){
            SimpleJsonReader.read(new StringReader((String)object), new Handler((SimpleJsonWriter)object4){
                final /* synthetic */ SimpleJsonWriter val$writer;
                {
                    this.val$writer = simpleJsonWriter;
                }

                @Override
                public void key(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
                    this.val$writer.key(string);
                }

                @Override
                public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
                    this.val$writer.beginObject();
                }

                @Override
                public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
                    this.val$writer.endObject();
                }

                @Override
                public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
                    this.val$writer.beginArray();
                }

                @Override
                public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
                    this.val$writer.endArray();
                }

                @Override
                public void nullValue(@NotNull SimpleJsonReader simpleJsonReader) {
                    this.val$writer.nul();
                }

                @Override
                public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
                    this.val$writer.value(string);
                }

                @Override
                public void value(@NotNull SimpleJsonReader simpleJsonReader, boolean bl) {
                    this.val$writer.value(bl);
                }

                @Override
                public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull Number number) {
                    if (number instanceof Integer) {
                        this.val$writer.value(number.intValue());
                    } else {
                        this.val$writer.value(number.doubleValue());
                    }
                }
            });
        }
        catch (Throwable object5) {
            object3 = object5;
            throw object5;
        }
        object4 = ((TextStringCollector)object2).getText();
        if (!((String)object).equals(object4)) {
            System.err.println("Different!");
            object3 = ((String)object).split("\n");
            String[] stringArray2 = ((String)object4).split("\n");
            int n = Math.max(((String[])object3).length, stringArray2.length);
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = i >= ((String[])object3).length ? "" : object3[i];
                String string3 = string = i >= stringArray2.length ? "" : stringArray2[i];
                if (!string2.equals(string)) {
                    System.out.println("DIFFERENCE:");
                }
                System.out.printf("%d: %s\n", i + 1, string2);
                System.out.printf("%d: %s\n", i + 1, string);
            }
            System.exit(1);
        } else {
            System.out.println("CORRECT!");
        }
        object3 = new LinkedHashMap();
        SimpleJsonReader.read(new StringReader((String)object), (Handler)new ValueHandler((Map)object3){
            final /* synthetic */ Map val$person;
            {
                this.val$person = map;
            }

            @Override
            @NotNull
            protected TemporaryHandler object() {
                return new ObjectHandler(){

                    @Override
                    @NotNull
                    protected TemporaryHandler objectValue(@NotNull String string) {
                        if ("address".equals(string)) {
                            final LinkedHashMap linkedHashMap = new LinkedHashMap();
                            val$person.put("address", linkedHashMap);
                            return new ObjectHandler(){

                                @Override
                                @NotNull
                                protected TemporaryHandler objectValue(@NotNull String string) {
                                    System.err.println("Unexpected object value for key " + string);
                                    return SKIP_HANDLER;
                                }

                                @Override
                                @NotNull
                                protected TemporaryHandler arrayValue(@NotNull String string) {
                                    System.err.println("Unexpected array value for key " + string);
                                    return SKIP_HANDLER;
                                }

                                @Override
                                protected void nullValue(@NotNull String string) {
                                    System.err.println("Unexpected null value for key " + string);
                                }

                                @Override
                                protected void value(@NotNull String string, @NotNull String string2) {
                                    switch (string) {
                                        case "street": 
                                        case "city": 
                                        case "country": {
                                            linkedHashMap.put(string, string2);
                                            break;
                                        }
                                        default: {
                                            System.err.println("Unexpected string value for key " + string);
                                        }
                                    }
                                }

                                @Override
                                protected void value(@NotNull String string, boolean bl) {
                                    System.err.println("Unexpected boolean value for key " + string);
                                }

                                @Override
                                protected void value(@NotNull String string, @NotNull Number number) {
                                    if ("zipcode".equals(string)) {
                                        linkedHashMap.put(string, number);
                                    } else {
                                        System.err.println("Unexpected number value for key " + string);
                                    }
                                }

                                @Override
                                public void initialize(@NotNull SimpleJsonReader simpleJsonReader) {
                                }

                                @Override
                                public void finish(@NotNull SimpleJsonReader simpleJsonReader) {
                                }
                            };
                        }
                        System.err.println("Unexpected object value for key " + string);
                        return SKIP_HANDLER;
                    }

                    @Override
                    @NotNull
                    protected TemporaryHandler arrayValue(@NotNull String string) {
                        if ("foods".equals(string)) {
                            final ArrayList arrayList = new ArrayList();
                            val$person.put("foods", arrayList);
                            return new ArrayHandler(){

                                @Override
                                @NotNull
                                protected TemporaryHandler objectElement(int n) {
                                    System.err.println("Unexpected object element for index " + n);
                                    return SKIP_HANDLER;
                                }

                                @Override
                                @NotNull
                                protected TemporaryHandler arrayElement(int n) {
                                    System.err.println("Unexpected array element for index " + n);
                                    return SKIP_HANDLER;
                                }

                                @Override
                                protected void nullElement(int n) {
                                    System.err.println("Unexpected null element for index " + n);
                                }

                                @Override
                                protected void element(int n, @NotNull String string) {
                                    assert (n == arrayList.size());
                                    arrayList.add(string);
                                }

                                @Override
                                protected void element(int n, boolean bl) {
                                    System.err.println("Unexpected boolean element for index " + n);
                                }

                                @Override
                                protected void element(int n, @NotNull Number number) {
                                    System.err.println("Unexpected number element for index " + n);
                                }

                                @Override
                                public void initialize(@NotNull SimpleJsonReader simpleJsonReader) {
                                }

                                @Override
                                public void finish(@NotNull SimpleJsonReader simpleJsonReader) {
                                }
                            };
                        }
                        System.err.println("Unexpected array value for key " + string);
                        return SKIP_HANDLER;
                    }

                    @Override
                    protected void nullValue(@NotNull String string) {
                        System.err.println("Unexpected null value for key " + string);
                    }

                    @Override
                    protected void value(@NotNull String string, @NotNull String string2) {
                        if ("name".equals(string)) {
                            val$person.put(string, string2);
                        } else {
                            System.err.printf("Unexpected key-value pair: %s -> %s\n", string, string2);
                        }
                    }

                    @Override
                    protected void value(@NotNull String string, boolean bl) {
                        if ("clever".equals(string)) {
                            val$person.put(string, bl);
                        } else {
                            System.err.printf("Unexpected key-value pair: %s -> %s\n", string, bl);
                        }
                    }

                    @Override
                    protected void value(@NotNull String string, @NotNull Number number) {
                        switch (string) {
                            case "age": {
                                assert (number instanceof Integer);
                                val$person.put(string, number);
                                break;
                            }
                            case "size": {
                                assert (number instanceof Double);
                                val$person.put(string, number);
                                break;
                            }
                            default: {
                                System.err.printf("Unexpected key-value pair: %s -> %s\n", string, number);
                            }
                        }
                    }

                    @Override
                    public void initialize(@NotNull SimpleJsonReader simpleJsonReader) {
                    }

                    @Override
                    public void finish(@NotNull SimpleJsonReader simpleJsonReader) {
                    }
                };
            }
        });
        System.out.println(object3);
        System.out.println(SimpleJsonReader.readToMap(new StringReader((String)object)));
    }

    public static class BooleanValueHandler
    implements Handler {
        @NotNull
        private final BooleanConsumer setter;

        public BooleanValueHandler(@NotNull BooleanConsumer booleanConsumer) {
            this.setter = booleanConsumer;
        }

        @Override
        public void key(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            throw new IllegalStateException("Unexpected key value: " + string);
        }

        @Override
        public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Unexpected object value!");
        }

        @Override
        public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Never should reach here!");
        }

        @Override
        public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Unexpected array value!");
        }

        @Override
        public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Never should reach here!");
        }

        @Override
        public void nullValue(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("null value not allowed!");
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            throw new IllegalStateException("Unexpected string value: " + string);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, boolean bl) {
            this.setter.accept(bl);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull Number number) {
            throw new IllegalStateException("Unexpected numeric value: " + number);
        }
    }

    public static class IntValueHandler
    implements Handler {
        @NotNull
        private final IntConsumer setter;

        public IntValueHandler(@NotNull IntConsumer intConsumer) {
            this.setter = intConsumer;
        }

        @Override
        public void key(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            throw new IllegalStateException("Unexpected key value: " + string);
        }

        @Override
        public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Unexpected object value!");
        }

        @Override
        public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Never should reach here!");
        }

        @Override
        public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Unexpected array value!");
        }

        @Override
        public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Never should reach here!");
        }

        @Override
        public void nullValue(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("null value not allowed!");
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            throw new IllegalStateException("Unexpected string value: " + string);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, boolean bl) {
            throw new IllegalStateException("Unexpected boolean value: " + bl);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull Number number) {
            this.setter.accept(number.intValue());
        }
    }

    public static class DoubleValueHandler
    implements Handler {
        @NotNull
        private final DoubleConsumer setter;

        public DoubleValueHandler(@NotNull DoubleConsumer doubleConsumer) {
            this.setter = doubleConsumer;
        }

        @Override
        public void key(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            throw new IllegalStateException("Unexpected key value: " + string);
        }

        @Override
        public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Unexpected object value!");
        }

        @Override
        public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Never should reach here!");
        }

        @Override
        public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Unexpected array value!");
        }

        @Override
        public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Never should reach here!");
        }

        @Override
        public void nullValue(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("null value not allowed!");
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            throw new IllegalStateException("Unexpected string value: " + string);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, boolean bl) {
            throw new IllegalStateException("Unexpected boolean value: " + bl);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull Number number) {
            this.setter.accept(number.doubleValue());
        }
    }

    public static class NumericValueHandler
    implements Handler {
        @NotNull
        private final Consumer<? super Number> setter;

        public NumericValueHandler(@NotNull Consumer<? super Number> consumer) {
            this.setter = consumer;
        }

        @Override
        public void key(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            throw new IllegalStateException("Unexpected key value: " + string);
        }

        @Override
        public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Unexpected object value!");
        }

        @Override
        public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Never should reach here!");
        }

        @Override
        public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Unexpected array value!");
        }

        @Override
        public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Never should reach here!");
        }

        @Override
        public void nullValue(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("null value not allowed!");
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            throw new IllegalStateException("Unexpected string value: " + string);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, boolean bl) {
            throw new IllegalStateException("Unexpected boolean value: " + bl);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull Number number) {
            this.setter.accept(number);
        }
    }

    public static class StringValueHandler
    implements Handler {
        @NotNull
        private final Consumer<? super String> setter;
        private final boolean allowNull;

        public StringValueHandler(@NotNull Consumer<? super String> consumer) {
            this(consumer, false);
        }

        public StringValueHandler(@NotNull Consumer<? super String> consumer, boolean bl) {
            this.setter = consumer;
            this.allowNull = bl;
        }

        @Override
        public void key(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            throw new IllegalStateException("Unexpected key value: " + string);
        }

        @Override
        public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Unexpected object value!");
        }

        @Override
        public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Never should reach here!");
        }

        @Override
        public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Unexpected array value!");
        }

        @Override
        public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Never should reach here!");
        }

        @Override
        public void nullValue(@NotNull SimpleJsonReader simpleJsonReader) {
            if (!this.allowNull) {
                throw new IllegalStateException("null value not allowed!");
            }
            this.setter.accept(null);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            this.setter.accept(string);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, boolean bl) {
            throw new IllegalStateException("Unexpected boolean value: " + bl);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull Number number) {
            throw new IllegalStateException("Unexpected numeric value: " + number);
        }
    }

    public static abstract class ValueHandler
    implements Handler {
        private boolean called;

        @Override
        public void key(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            throw new IllegalStateException("Expecting a value but got key " + string + "!");
        }

        private void checkCalled() {
            if (this.called) {
                throw new IllegalStateException("Value handler used for more than one value!");
            }
            this.called = true;
        }

        @Override
        public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
            this.checkCalled();
            final TemporaryHandler temporaryHandler = this.object();
            temporaryHandler.initialize(simpleJsonReader);
            simpleJsonReader.pushSubHandler(new HandlerWrapper(temporaryHandler){
                int subObjDepth;
                {
                    super(handler);
                    this.subObjDepth = 1;
                }

                @Override
                public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
                    ++this.subObjDepth;
                    super.beginObject(simpleJsonReader);
                }

                @Override
                public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
                    if (--this.subObjDepth <= 0) {
                        Handler handler = simpleJsonReader.popSubHandler();
                        assert (handler == this);
                        temporaryHandler.finish(simpleJsonReader);
                        simpleJsonReader.getSubHandler().endObject(simpleJsonReader);
                    } else {
                        super.endObject(simpleJsonReader);
                    }
                }
            });
        }

        @Override
        public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
            this.checkCalled();
            final TemporaryHandler temporaryHandler = this.array();
            temporaryHandler.initialize(simpleJsonReader);
            simpleJsonReader.pushSubHandler(new HandlerWrapper(temporaryHandler){
                int subArrayDepth;
                {
                    super(handler);
                    this.subArrayDepth = 0;
                }

                @Override
                public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
                    ++this.subArrayDepth;
                    super.beginArray(simpleJsonReader);
                }

                @Override
                public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
                    if (--this.subArrayDepth <= 0) {
                        Handler handler = simpleJsonReader.popSubHandler();
                        assert (handler == this);
                        temporaryHandler.finish(simpleJsonReader);
                    } else {
                        super.endArray(simpleJsonReader);
                    }
                }
            });
        }

        @Override
        public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
            throw new IllegalStateException("Not expecting to reach here!");
        }

        @Override
        public void nullValue(@NotNull SimpleJsonReader simpleJsonReader) {
            this.checkCalled();
            this.nullValue();
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            this.checkCalled();
            this.value(string);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, boolean bl) {
            this.checkCalled();
            this.value(bl);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull Number number) {
            this.checkCalled();
            this.value(number);
        }

        @NotNull
        protected abstract TemporaryHandler object();

        @NotNull
        protected TemporaryHandler array() {
            throw new IllegalStateException("Not expecting an array value!");
        }

        protected void nullValue() {
            throw new IllegalStateException("Not expecting a null value!");
        }

        protected void value(@NotNull String string) {
            throw new IllegalStateException(String.format("Not expecting a string value: %s!", string));
        }

        protected void value(@NotNull Number number) {
            throw new IllegalStateException(String.format("Not expecting a number value: %s!", number));
        }

        protected void value(boolean bl) {
            throw new IllegalStateException(String.format("Not expecting a string value: %s!", bl));
        }
    }

    public static abstract class ArrayHandler
    implements TemporaryHandler {
        private int index = 0;

        @Override
        public void key(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            throw new IllegalStateException("Not expecting a key inside array elements!");
        }

        @Override
        public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
            final TemporaryHandler temporaryHandler = this.objectElement(this.index++);
            temporaryHandler.initialize(simpleJsonReader);
            simpleJsonReader.pushSubHandler(new HandlerWrapper(temporaryHandler){
                int subObjDepth;
                {
                    super(handler);
                    this.subObjDepth = 1;
                }

                @Override
                public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
                    ++this.subObjDepth;
                    super.beginObject(simpleJsonReader);
                }

                @Override
                public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
                    if (--this.subObjDepth <= 0) {
                        Handler handler = simpleJsonReader.popSubHandler();
                        assert (handler == this);
                        temporaryHandler.finish(simpleJsonReader);
                        simpleJsonReader.getSubHandler().endObject(simpleJsonReader);
                    } else {
                        super.endObject(simpleJsonReader);
                    }
                }
            });
        }

        @Override
        public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
            final TemporaryHandler temporaryHandler = this.arrayElement(this.index++);
            temporaryHandler.initialize(simpleJsonReader);
            simpleJsonReader.pushSubHandler(new HandlerWrapper(temporaryHandler){
                int subArrayDepth;
                {
                    super(handler);
                    this.subArrayDepth = 0;
                }

                @Override
                public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
                    ++this.subArrayDepth;
                    super.beginArray(simpleJsonReader);
                }

                @Override
                public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
                    if (--this.subArrayDepth <= 0) {
                        Handler handler = simpleJsonReader.popSubHandler();
                        assert (handler == this);
                        temporaryHandler.finish(simpleJsonReader);
                        simpleJsonReader.getSubHandler().endArray(simpleJsonReader);
                    } else {
                        super.endArray(simpleJsonReader);
                    }
                }
            });
        }

        @Override
        public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void nullValue(@NotNull SimpleJsonReader simpleJsonReader) {
            this.nullElement(this.index++);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            this.element(this.index++, string);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, boolean bl) {
            this.element(this.index++, bl);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull Number number) {
            this.element(this.index++, number);
        }

        @NotNull
        protected abstract TemporaryHandler objectElement(int var1);

        @NotNull
        protected abstract TemporaryHandler arrayElement(int var1);

        protected abstract void nullElement(int var1);

        protected abstract void element(int var1, @NotNull String var2);

        protected abstract void element(int var1, boolean var2);

        protected abstract void element(int var1, @NotNull Number var2);
    }

    public static abstract class ObjectHandler
    implements TemporaryHandler {
        private String lastKey;

        @Override
        public void key(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            assert (Objects.isNull(this.lastKey));
            this.lastKey = string;
        }

        @Override
        public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
            Objects.requireNonNull(this.lastKey);
            final TemporaryHandler temporaryHandler = this.objectValue(this.lastKey);
            temporaryHandler.initialize(simpleJsonReader);
            simpleJsonReader.pushSubHandler(new HandlerWrapper(temporaryHandler){
                int subObjDepth;
                {
                    super(handler);
                    this.subObjDepth = 1;
                }

                @Override
                public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
                    ++this.subObjDepth;
                    super.beginObject(simpleJsonReader);
                }

                @Override
                public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
                    if (--this.subObjDepth <= 0) {
                        Handler handler = simpleJsonReader.popSubHandler();
                        assert (handler == this);
                        temporaryHandler.finish(simpleJsonReader);
                        lastKey = null;
                        simpleJsonReader.getSubHandler().endObject(simpleJsonReader);
                    } else {
                        super.endObject(simpleJsonReader);
                    }
                }
            });
        }

        @Override
        public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
            Objects.requireNonNull(this.lastKey);
            final TemporaryHandler temporaryHandler = this.arrayValue(this.lastKey);
            temporaryHandler.initialize(simpleJsonReader);
            simpleJsonReader.pushSubHandler(new HandlerWrapper(temporaryHandler){
                int subArrayDepth;
                {
                    super(handler);
                    this.subArrayDepth = 1;
                }

                @Override
                public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
                    ++this.subArrayDepth;
                    super.beginArray(simpleJsonReader);
                }

                @Override
                public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
                    if (--this.subArrayDepth <= 0) {
                        Handler handler = simpleJsonReader.popSubHandler();
                        assert (handler == this);
                        temporaryHandler.finish(simpleJsonReader);
                        lastKey = null;
                        simpleJsonReader.getSubHandler().endArray(simpleJsonReader);
                    } else {
                        super.endArray(simpleJsonReader);
                    }
                }
            });
        }

        @Override
        public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void nullValue(@NotNull SimpleJsonReader simpleJsonReader) {
            Objects.requireNonNull(this.lastKey);
            this.nullValue(this.lastKey);
            this.lastKey = null;
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            Objects.requireNonNull(this.lastKey);
            this.value(this.lastKey, string);
            this.lastKey = null;
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, boolean bl) {
            Objects.requireNonNull(this.lastKey);
            this.value(this.lastKey, bl);
            this.lastKey = null;
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull Number number) {
            Objects.requireNonNull(this.lastKey);
            this.value(this.lastKey, number);
            this.lastKey = null;
        }

        @NotNull
        protected abstract TemporaryHandler objectValue(@NotNull String var1);

        @NotNull
        protected abstract TemporaryHandler arrayValue(@NotNull String var1);

        protected abstract void nullValue(@NotNull String var1);

        protected abstract void value(@NotNull String var1, @NotNull String var2);

        protected abstract void value(@NotNull String var1, boolean var2);

        protected abstract void value(@NotNull String var1, @NotNull Number var2);
    }

    public static class HandlerWrapper
    implements Handler {
        @NotNull
        protected final Handler wrapped;

        public HandlerWrapper(@NotNull Handler handler) {
            this.wrapped = handler;
        }

        @Override
        public void key(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            this.wrapped.key(simpleJsonReader, string);
        }

        @Override
        public void beginObject(@NotNull SimpleJsonReader simpleJsonReader) {
            this.wrapped.beginObject(simpleJsonReader);
        }

        @Override
        public void endObject(@NotNull SimpleJsonReader simpleJsonReader) {
            this.wrapped.endObject(simpleJsonReader);
        }

        @Override
        public void beginArray(@NotNull SimpleJsonReader simpleJsonReader) {
            this.wrapped.beginArray(simpleJsonReader);
        }

        @Override
        public void endArray(@NotNull SimpleJsonReader simpleJsonReader) {
            this.wrapped.endArray(simpleJsonReader);
        }

        @Override
        public void nullValue(@NotNull SimpleJsonReader simpleJsonReader) {
            this.wrapped.nullValue(simpleJsonReader);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull String string) {
            this.wrapped.value(simpleJsonReader, string);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, boolean bl) {
            this.wrapped.value(simpleJsonReader, bl);
        }

        @Override
        public void value(@NotNull SimpleJsonReader simpleJsonReader, @NotNull Number number) {
            this.wrapped.value(simpleJsonReader, number);
        }
    }

    public static interface TemporaryHandler
    extends Handler {
        public void initialize(@NotNull SimpleJsonReader var1);

        public void finish(@NotNull SimpleJsonReader var1);
    }

    public static interface Handler {
        public void key(@NotNull SimpleJsonReader var1, @NotNull String var2);

        public void beginObject(@NotNull SimpleJsonReader var1);

        public void endObject(@NotNull SimpleJsonReader var1);

        public void beginArray(@NotNull SimpleJsonReader var1);

        public void endArray(@NotNull SimpleJsonReader var1);

        public void nullValue(@NotNull SimpleJsonReader var1);

        public void value(@NotNull SimpleJsonReader var1, @NotNull String var2);

        public void value(@NotNull SimpleJsonReader var1, boolean var2);

        public void value(@NotNull SimpleJsonReader var1, @NotNull Number var2);
    }

    private static class Tokenizer {
        @NotNull
        private final LineNumberReader reader;
        int nextChar = Integer.MIN_VALUE;

        Tokenizer(@NotNull Reader reader) {
            this.reader = reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
        }

        private int nextChar() throws IOException {
            if (this.nextChar != Integer.MIN_VALUE) {
                int n = this.nextChar;
                this.nextChar = Integer.MIN_VALUE;
                return n;
            }
            return this.reader.read();
        }

        private void unget(int n) {
            assert (this.nextChar == Integer.MIN_VALUE || this.nextChar == n);
            this.nextChar = n;
        }

        private int getLineNumber() {
            if (this.nextChar == 10) {
                return this.reader.getLineNumber() - 1;
            }
            return this.reader.getLineNumber();
        }

        @Nullable
        public Token nextToken() throws IOException {
            int n = this.nextNonWhite();
            switch (n) {
                case -1: {
                    return null;
                }
                case 58: {
                    return Token.COLON;
                }
                case 44: {
                    return Token.COMMA;
                }
                case 34: {
                    return this.readString((char)n);
                }
                case 123: {
                    return Token.OPEN_BRACE;
                }
                case 125: {
                    return Token.CLOSE_BRACE;
                }
                case 91: {
                    return Token.OPEN_BRACKET;
                }
                case 93: {
                    return Token.CLOSE_BRACKET;
                }
                case 116: {
                    this.unget(n);
                    return this.expectWord("true", Token.TRUE);
                }
                case 102: {
                    this.unget(n);
                    return this.expectWord("false", Token.FALSE);
                }
                case 110: {
                    this.unget(n);
                    return this.expectWord("null", Token.NULL);
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.readNumber((char)n);
                }
            }
            throw new IOException("Unexpected character " + (char)n + " in line " + this.getLineNumber());
        }

        @NotNull
        private Token expectWord(@NotNull String string, @NotNull Token token) throws IOException {
            String string2 = this.readLetters();
            if (string.equals(string2)) {
                return token;
            }
            throw new IOException("Unexpected keyword " + string2 + " in line " + this.getLineNumber());
        }

        @NotNull
        private String readLetters() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.nextChar();
            while (n >= 0 && Character.isLetter(n)) {
                stringBuilder.append((char)n);
                n = this.nextChar();
            }
            this.unget(n);
            return stringBuilder.toString();
        }

        private int nextNonWhite() throws IOException {
            int n;
            while ((n = this.nextChar()) >= 0 && Character.isWhitespace((char)n)) {
            }
            return n;
        }

        @NotNull
        private Token readNumber(char c) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            if (c != '+') {
                stringBuilder.append(c);
            }
            int n = this.nextChar();
            while (Tokenizer.isForFloatingPoint(n)) {
                stringBuilder.append((char)n);
                n = this.nextChar();
            }
            this.unget(n);
            String string = stringBuilder.toString();
            try {
                return new Token(Token.Type.IntegerValue, Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return new Token(Token.Type.DoubleValue, Double.parseDouble(string));
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new IOException(String.format("Not a number in line %d: %s", this.getLineNumber(), string), numberFormatException2);
                }
            }
        }

        private static boolean isDigit(int n) {
            return n <= 57 && n >= 48;
        }

        private static boolean isForFloatingPoint(int n) {
            return Tokenizer.isDigit(n) || n == 46 || n == 101 || n == 69 || n == 45 || n == 43;
        }

        private static int hexDigit(int n) throws IOException {
            if (n >= 48) {
                if (n <= 57) {
                    return n - 48;
                }
                if (n >= 65) {
                    if (n <= 70) {
                        return n - 65 + 10;
                    }
                    if (n >= 97 && n <= 102) {
                        return n - 97 + 10;
                    }
                }
            }
            throw new IOException(String.format("Invalid hexadecimal digit: '%s'", Character.valueOf((char)n)));
        }

        @NotNull
        private Token readString(char c) throws IOException {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.reader.getLineNumber();
            int n2 = this.reader.read();
            int n3 = 0;
            int n4 = 0;
            while (n2 != -1) {
                if (n4 > 0) {
                    n3 = 16 * n3 + Tokenizer.hexDigit(n2);
                    if (--n4 == 0) {
                        stringBuilder.append((char)n3);
                    }
                } else if (bl) {
                    switch (n2) {
                        case 110: {
                            stringBuilder.append('\n');
                            break;
                        }
                        case 114: {
                            stringBuilder.append('\r');
                            break;
                        }
                        case 116: {
                            stringBuilder.append('\t');
                            break;
                        }
                        case 102: {
                            stringBuilder.append('\f');
                            break;
                        }
                        case 98: {
                            stringBuilder.append('\b');
                            break;
                        }
                        case 117: {
                            n3 = 0;
                            n4 = 4;
                            break;
                        }
                        default: {
                            stringBuilder.append((char)n2);
                        }
                    }
                    bl = false;
                } else {
                    if (n2 == c) {
                        return new Token(Token.Type.StringValue, stringBuilder.toString());
                    }
                    if (n2 == 92) {
                        bl = true;
                    } else {
                        stringBuilder.append((char)n2);
                    }
                }
                n2 = this.reader.read();
            }
            throw new IOException("No ending quote for string starting in line " + n);
        }
    }

    private static class Token {
        @NotNull
        private final Type type;
        @NotNull
        private final Object value;
        public static final Token NULL = new Token(Type.NullValue, "null");
        public static final Token TRUE = new Token(Type.TrueValue, Boolean.TRUE);
        public static final Token FALSE = new Token(Type.FalseValue, Boolean.FALSE);
        public static final Token COLON = new Token(Type.Colon, Character.valueOf(':'));
        public static final Token COMMA = new Token(Type.Comma, Character.valueOf(','));
        public static final Token OPEN_BRACE = new Token(Type.OpenBrace, Character.valueOf('{'));
        public static final Token CLOSE_BRACE = new Token(Type.CloseBrace, Character.valueOf('}'));
        public static final Token OPEN_BRACKET = new Token(Type.OpenBracket, Character.valueOf('['));
        public static final Token CLOSE_BRACKET = new Token(Type.CloseBracket, Character.valueOf(']'));

        Token(@NotNull Type type, @NotNull Object object) {
            this.type = type;
            this.value = object;
        }

        public String toString() {
            return this.value.toString();
        }

        private static enum Type {
            Colon,
            Comma,
            OpenBrace,
            CloseBrace,
            OpenBracket,
            CloseBracket,
            NullValue,
            TrueValue,
            FalseValue,
            IntegerValue,
            DoubleValue,
            StringValue;

        }
    }

    private static class MapArrayHandler
    extends ArrayHandler {
        @NotNull
        private final Consumer<Object[]> arrayCollector;
        @NotNull
        private final List<Object> elements = new LinkedList<Object>();

        public MapArrayHandler(@NotNull Consumer<Object[]> consumer) {
            this.arrayCollector = consumer;
        }

        @Override
        public void initialize(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void finish(@NotNull SimpleJsonReader simpleJsonReader) {
            this.arrayCollector.accept(this.elements.toArray());
        }

        @Override
        @NotNull
        protected TemporaryHandler objectElement(int n) {
            MapObjectHandler mapObjectHandler = new MapObjectHandler();
            this.elements.add(mapObjectHandler.map);
            return mapObjectHandler;
        }

        @Override
        @NotNull
        protected TemporaryHandler arrayElement(int n) {
            return new MapArrayHandler(this.elements::add);
        }

        @Override
        protected void nullElement(int n) {
            this.elements.add(null);
        }

        @Override
        protected void element(int n, @NotNull String string) {
            this.elements.add(string);
        }

        @Override
        protected void element(int n, boolean bl) {
            this.elements.add(bl);
        }

        @Override
        protected void element(int n, @NotNull Number number) {
            this.elements.add(number);
        }
    }

    public static class MapObjectHandler
    extends ObjectHandler {
        @NotNull
        private final Map<String, Object> map = new LinkedHashMap<String, Object>();

        @Override
        public void initialize(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        public void finish(@NotNull SimpleJsonReader simpleJsonReader) {
        }

        @Override
        @NotNull
        protected TemporaryHandler objectValue(@NotNull String string) {
            MapObjectHandler mapObjectHandler = new MapObjectHandler();
            this.map.put(string, mapObjectHandler.map);
            return mapObjectHandler;
        }

        @Override
        @NotNull
        protected TemporaryHandler arrayValue(@NotNull String string) {
            return new MapArrayHandler(objectArray -> this.map.put(string, objectArray));
        }

        @Override
        protected void nullValue(@NotNull String string) {
            this.map.put(string, null);
        }

        @Override
        protected void value(@NotNull String string, @NotNull String string2) {
            this.map.put(string, string2);
        }

        @Override
        protected void value(@NotNull String string, boolean bl) {
            this.map.put(string, bl);
        }

        @Override
        protected void value(@NotNull String string, @NotNull Number number) {
            this.map.put(string, number);
        }

        @NotNull
        public Map<String, Object> getMap() {
            return this.map;
        }
    }
}

