/*
 * Decompiled with CFR 0.152.
 */
package de.caff.io.json;

import de.caff.annotation.NotNull;
import de.caff.generics.CharIndexable;
import de.caff.io.json.SimpleJsonWriter;
import java.io.IOException;

public class Json {
    private Json() {
    }

    @NotNull
    public static String maskForOutput(@NotNull String string) {
        if (string.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            String string2;
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    string2 = "\\\\";
                    break;
                }
                case '\"': {
                    string2 = "\\\"";
                    break;
                }
                case '\n': {
                    string2 = "\\n";
                    break;
                }
                case '\r': {
                    string2 = "\\r";
                    break;
                }
                case '\t': {
                    string2 = "\\t";
                    break;
                }
                case '\b': {
                    string2 = "\\b";
                    break;
                }
                case '\f': {
                    string2 = "\\f";
                    break;
                }
                default: {
                    if (c < ' ') {
                        string2 = String.format("\\u%04X", c);
                        break;
                    }
                    if (stringBuilder == null) continue block9;
                    stringBuilder.append(c);
                    continue block9;
                }
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string.substring(0, i));
            }
            stringBuilder.append(string2);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    @NotNull
    public static String unmaskFromInput(@NotNull String string) throws IOException {
        StringBuilder stringBuilder = null;
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl) {
                char c2;
                int n2 = i;
                bl = false;
                switch (c) {
                    case 'n': {
                        c2 = '\n';
                        break;
                    }
                    case 'r': {
                        c2 = '\r';
                        break;
                    }
                    case 't': {
                        c2 = '\t';
                        break;
                    }
                    case 'b': {
                        c2 = '\b';
                        break;
                    }
                    case 'f': {
                        c2 = '\f';
                        break;
                    }
                    case 'u': {
                        int n3 = i + 1;
                        int n4 = n3 + 4;
                        if (n4 > n) {
                            throw new IOException("Not enough digits for unicode escape \\u!");
                        }
                        String string2 = string.substring(n3, n4);
                        try {
                            c2 = (char)Integer.parseInt(string2, 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IOException("Not a valid unicode escape: \\u" + string2, numberFormatException);
                        }
                        i = n4 - 1;
                        break;
                    }
                    default: {
                        c2 = c;
                    }
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.substring(0, n2 - 1));
                }
                stringBuilder.append(c2);
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        String string = CharIndexable.viewByIndex((int)256, n -> (char)n).makeString();
        String string2 = Json.maskForOutput(string);
        System.out.println(string2);
        String string3 = Json.unmaskFromInput(string2);
        if (!string.equals(string3)) {
            System.err.printf("Different:\n%s\n%s\n", string, string3);
            System.exit(1);
        }
    }

    public static enum Env {
        Object(SimpleJsonWriter.State.Key){

            @Override
            void close(@NotNull SimpleJsonWriter simpleJsonWriter) {
                simpleJsonWriter.endObject();
            }
        }
        ,
        Array(SimpleJsonWriter.State.Value){

            @Override
            void close(@NotNull SimpleJsonWriter simpleJsonWriter) {
                simpleJsonWriter.endArray();
            }
        };

        @NotNull
        final SimpleJsonWriter.State defaultState;

        private Env(SimpleJsonWriter.State state) {
            this.defaultState = state;
        }

        abstract void close(@NotNull SimpleJsonWriter var1);
    }
}

