/*
 * Decompiled with CFR 0.152.
 */
package de.caff.io;

import de.caff.annotation.NotNull;
import de.caff.util.ByteRingBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class LimitedByteArrayOutputStream
extends OutputStream {
    @NotNull
    private final ByteRingBuffer buffer;

    public LimitedByteArrayOutputStream(int n) {
        this.buffer = new ByteRingBuffer(n);
    }

    @Override
    public void write(int n) throws IOException {
        this.buffer.append(n);
    }

    @Override
    public void write(@NotNull byte[] byArray) throws IOException {
        this.buffer.append(byArray);
    }

    @Override
    public void write(@NotNull byte[] byArray, int n, int n2) throws IOException {
        this.buffer.append(byArray, n, n2);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @NotNull
    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public void reset() {
        this.buffer.clear();
    }

    public long getTotalNumberOfBytes() {
        return this.buffer.getNumberOfCollectedBytes();
    }

    @NotNull
    public String toString(@NotNull Charset charset) {
        return new String(this.buffer.toByteArray(), charset);
    }

    @NotNull
    public String toString() {
        return this.toString(Charset.defaultCharset());
    }
}

