/*
 * Decompiled with CFR 0.152.
 */
package de.caff.io;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.util.LongCounter;
import de.caff.util.debug.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamPipe
implements Runnable {
    @NotNull
    private final InputStream is;
    @NotNull
    private final OutputStream os;
    @NotNull
    private final LongCounter totalNumberOfBytes = LongCounter.THREAD_SAFE.create();
    @Nullable
    private IOException error;

    public InputStreamPipe(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
        this.is = inputStream;
        this.os = outputStream;
    }

    public long getTotalByteCount() {
        return this.totalNumberOfBytes.getValue();
    }

    @Nullable
    public IOException getError() {
        return this.error;
    }

    @Override
    public void run() {
        byte[] byArray = new byte[256];
        try {
            int n;
            while ((n = this.is.read(byArray)) > 0) {
                this.totalNumberOfBytes.add((long)n);
                this.os.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            this.error = iOException;
            Debug.error(iOException);
        }
    }

    @NotNull
    public static InputStreamPipe startOn(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) {
        InputStreamPipe inputStreamPipe = new InputStreamPipe(inputStream, outputStream);
        new Thread(inputStreamPipe).start();
        return inputStreamPipe;
    }
}

