/*
 * Decompiled with CFR 0.152.
 */
package de.caff.io;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Indexable;
import de.caff.util.TextLineRingBuffer;
import de.caff.util.debug.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;

public class InputStreamLineBuffer
implements Runnable {
    public static final int MAXIMUM_ARRAY_SIZE = 0x7FFFFFF7;
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    @NotNull
    private final TextLineRingBuffer lineBuffer;
    @NotNull
    private final InputStream is;
    @Nullable
    private IOException error;

    public InputStreamLineBuffer(@NotNull InputStream inputStream, int n) {
        this(inputStream, n, Charset.defaultCharset());
    }

    public InputStreamLineBuffer(@NotNull InputStream inputStream, int n, @NotNull Charset charset) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize has to be positive!");
        }
        this.is = inputStream;
        this.lineBuffer = new TextLineRingBuffer(n, charset);
    }

    @Nullable
    public IOException getError() {
        return this.error;
    }

    @NotNull
    public Indexable<String> viewLines() {
        return this.lineBuffer.viewLines();
    }

    @NotNull
    public Indexable<String> toLineIndexable() {
        return this.lineBuffer.toLineIndexable();
    }

    @NotNull
    public List<String> toLineList() {
        return this.lineBuffer.toLineList();
    }

    @NotNull
    public String[] getLines() {
        return this.lineBuffer.toLineArray();
    }

    @NotNull
    public String getOutput() {
        return this.lineBuffer.toString();
    }

    public void clearOutput() {
        this.lineBuffer.clear();
    }

    public long getTotalByteCount() {
        return this.lineBuffer.getNumberOfCollectedBytes();
    }

    @Override
    public void run() {
        byte[] byArray = new byte[256];
        try {
            int n;
            while ((n = this.is.read(byArray)) > 0) {
                this.lineBuffer.append(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            this.error = iOException;
            Debug.error(iOException);
        }
    }

    @NotNull
    public static InputStreamLineBuffer startOn(@NotNull InputStream inputStream) {
        return InputStreamLineBuffer.startOn(inputStream, 65536);
    }

    @NotNull
    public static InputStreamLineBuffer startOn(@NotNull InputStream inputStream, int n) {
        InputStreamLineBuffer inputStreamLineBuffer = new InputStreamLineBuffer(inputStream, n);
        new Thread(inputStreamLineBuffer).start();
        return inputStreamLineBuffer;
    }

    public String toString() {
        return this.getOutput();
    }
}

