/*
 * Decompiled with CFR 0.152.
 */
package de.caff.io;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.ByteRingBuffer;
import de.caff.util.debug.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class InputStreamBuffer
implements Runnable {
    public static final int MAXIMUM_ARRAY_SIZE = 0x7FFFFFF7;
    @NotNull
    private final ByteRingBuffer byteBuffer;
    @NotNull
    private final InputStream is;
    @Nullable
    private IOException error;

    public InputStreamBuffer(@NotNull InputStream inputStream, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize has to be positive!");
        }
        this.is = inputStream;
        this.byteBuffer = new ByteRingBuffer(n);
    }

    @Nullable
    public IOException getError() {
        return this.error;
    }

    @NotNull
    public byte[] getBinaryOutput() {
        return this.byteBuffer.toByteArray();
    }

    @NotNull
    public String getOutput() {
        return this.getOutput(Charset.defaultCharset());
    }

    @NotNull
    public String getOutput(@NotNull Charset charset) {
        return new String(this.getBinaryOutput(), charset);
    }

    public void clearOutput() {
        this.byteBuffer.clear();
    }

    public long getTotalByteCount() {
        return this.byteBuffer.getNumberOfCollectedBytes();
    }

    @Override
    public void run() {
        byte[] byArray = new byte[256];
        try {
            int n;
            while ((n = this.is.read(byArray)) > 0) {
                this.byteBuffer.append(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            this.error = iOException;
            Debug.error(iOException);
        }
    }

    @NotNull
    public static InputStreamBuffer startOn(@NotNull InputStream inputStream) {
        return InputStreamBuffer.startOn(inputStream, 0x7FFFFFF7);
    }

    @NotNull
    public static InputStreamBuffer startOn(@NotNull InputStream inputStream, int n) {
        InputStreamBuffer inputStreamBuffer = new InputStreamBuffer(inputStream, n);
        new Thread(inputStreamBuffer).start();
        return inputStreamBuffer;
    }

    public String toString() {
        return this.getOutput();
    }
}

