/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n;

import de.caff.annotation.NotNull;
import de.caff.util.Base64;
import de.caff.util.debug.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlResourceBundle
extends ResourceBundle {
    public static final String EXTENSION = ".resource.xml";
    public static final String TAG_I18N = "i18n";
    public static final String TAG_GROUP = "grp";
    public static final String TAG_RESOURCE = "res";
    public static final String TAG_ACTION = "action";
    public static final String ATTR_KEY = "key";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_SUBTYPE = "subtype";
    public static final String ATTR_COMMENT = "comment";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_INHERET = "inheret";
    public static final String ATTR_NAME = "name";
    public static final int MY_VERSION = 1;
    private static final Pattern PATTERN_LINE_END = Pattern.compile("\n");
    private static final Map<String, ValueType> converterMapping = new HashMap<String, ValueType>();
    private static final ValueType STRING_VALUE_TYPE = new AbstractBasicValueType("String"){

        @Override
        public String valueToString(Object object) {
            return XmlResourceBundle.escapeForXml(object.toString());
        }

        @Override
        public Object stringToValue(String string) {
            return XmlResourceBundle.unescapeFromXml(string);
        }

        @Override
        public boolean equals(Object object, Object object2) {
            return object.equals(object2);
        }
    };
    private static final ValueType STRING_ARRAY_VALUE_TYPE = new AbstractBasicValueType("String[]"){

        @Override
        public String valueToString(Object object) {
            String[] stringArray = (String[])object;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(XmlResourceBundle.escapeForXml(stringArray[i]));
                if (i >= stringArray.length - 1) continue;
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }

        @Override
        public Object stringToValue(String string) {
            String[] stringArray = PATTERN_LINE_END.split(string);
            for (int i = stringArray.length - 1; i >= 0; --i) {
                stringArray[i] = XmlResourceBundle.unescapeFromXml(stringArray[i]);
            }
            return stringArray;
        }

        @Override
        public boolean equals(Object object, Object object2) {
            return Arrays.equals((String[])object, (String[])object2);
        }
    };
    public static final ValueType OBJECT_VALUE_TYPE = new AbstractBasicValueType("Object"){

        @Override
        public String valueToString(Object object) {
            try {
                return Base64.encodeObject((Serializable)object);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Not able to serialize object! Reason: " + throwable);
            }
        }

        @Override
        public Object stringToValue(String string) {
            try {
                return Base64.decodeToObject(string);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Not able to serialize object! Reason: " + throwable);
            }
        }

        @Override
        public boolean equals(@NotNull Object object, @NotNull Object object2) {
            return object.equals(object2);
        }
    };
    private I18nGroup root = new I18nGroup();
    private final Map<String, ResourceNode> resourceMap = new HashMap<String, ResourceNode>();

    private static String escapeForXml(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(2 * n);
        block10: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block10;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block10;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String unescapeFromXml(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (i < n - 1) {
                    c = string.charAt(++i);
                    switch (c) {
                        case '\\': {
                            stringBuilder.append(c);
                            break;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            break;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            break;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            break;
                        }
                        default: {
                            Debug.error("Unknown escape sequence: \\" + c);
                            stringBuilder.append(c);
                            break;
                        }
                    }
                    continue;
                }
                Debug.error("Pending \\");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public XmlResourceBundle(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        if (inputStream != null) {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)new MyHandler());
        }
    }

    public XmlResourceBundle() {
    }

    @Override
    @NotNull
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.resourceMap.keySet());
    }

    @Override
    protected Object handleGetObject(@NotNull String string) {
        Resource resource = (Resource)this.resourceMap.get(string);
        return resource != null ? resource.getValue() : null;
    }

    public String getComment() {
        return this.root.getComment();
    }

    public void putStringResource(String string, String string2) {
        this.putStringResource(string, string2, null);
    }

    public void putStringResource(String string, String string2, String string3) {
        this.putResource(string, string2, STRING_VALUE_TYPE, string3);
    }

    public void putStringArrayResource(String string, String[] stringArray) {
        this.putStringArrayResource(string, stringArray, null);
    }

    public void putStringArrayResource(String string, String[] stringArray, String string2) {
        this.putResource(string, stringArray, STRING_ARRAY_VALUE_TYPE, string2);
    }

    public void putObjectResource(String string, Serializable serializable) {
        this.putObjectResource(string, serializable, null);
    }

    public void putObjectResource(String string, Serializable serializable, String string2) {
        this.putResource(string, serializable, OBJECT_VALUE_TYPE, string2);
    }

    public void putResource(String string, Object object, ValueType valueType) {
        this.putResource(string, object, valueType, null);
    }

    public void putInheretedResource(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null key not allowed!");
        }
        this.putResource(new Resource(string));
    }

    private void putResource(ResourceNode resourceNode) {
        String string = resourceNode.getId();
        ResourceGroup resourceGroup = this.root;
        String string2 = ResourceActionGroup.getIdForSubGroup(string);
        if (string2 != null) {
            ResourceActionGroup resourceActionGroup = (ResourceActionGroup)this.root.getSubNode(string2);
            if (resourceActionGroup == null) {
                resourceActionGroup = new ResourceActionGroup(string2);
                this.root.addNode(resourceActionGroup);
            }
            resourceGroup = resourceActionGroup;
        }
        resourceGroup.addNode(resourceNode);
        resourceNode.registerResources(this.resourceMap);
    }

    public void putResource(String string, Object object, ValueType valueType, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("null key not allowed!");
        }
        if (object == null) {
            throw new IllegalArgumentException("null value not allowed!");
        }
        if (valueType == null) {
            throw new IllegalArgumentException("null type not allowed!");
        }
        Resource resource = new Resource(string, object, valueType, string2);
        this.putResource(resource);
    }

    private static void write(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes("utf-8"));
        outputStream.write(10);
    }

    public void saveXml(OutputStream outputStream) throws IOException {
        XmlResourceBundle.write(outputStream, "<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        XmlResourceBundle.write(outputStream, this.root.toXml());
    }

    public static ResourceBundle getResourceBundle(String string) {
        return XmlResourceBundle.getResourceBundle(string, Locale.getDefault(), ClassLoader.getSystemClassLoader());
    }

    public static ResourceBundle getResourceBundle(String string, Locale locale) {
        return XmlResourceBundle.getResourceBundle(string, locale, ClassLoader.getSystemClassLoader());
    }

    public static ResourceBundle getResourceBundle(String string, Locale locale, ClassLoader classLoader) {
        return ResourceBundle.getBundle(string, locale == null ? Locale.getDefault() : locale, classLoader);
    }

    private static void addAttribute(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(' ').append(XmlResourceBundle.escapeForXml(string)).append("=\"").append(XmlResourceBundle.escapeForXml(string2)).append('\"');
    }

    public static void main(String[] stringArray) throws IOException, SAXException, ParserConfigurationException {
        XmlResourceBundle xmlResourceBundle = new XmlResourceBundle();
        xmlResourceBundle.putStringResource("foo", "bar");
        xmlResourceBundle.putStringResource("str", "blah", "Just a string \u263a");
        xmlResourceBundle.putStringResource("ugly: \u00c4\u00d6\u00dc", "&amp;<=\"\"\u00e4\u00f6\u00fc\u00df>");
        xmlResourceBundle.putStringArrayResource("arr", new String[]{"a", "bb", "c\nd\ne"});
        xmlResourceBundle.putObjectResource("object", (Serializable)((Object)"A string handled as an object"), "what about objects?");
        xmlResourceBundle.putInheretedResource("inhereted");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        xmlResourceBundle.saveXml(byteArrayOutputStream);
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        System.out.println(new String(byArray, "utf-8"));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        XmlResourceBundle xmlResourceBundle2 = new XmlResourceBundle(byteArrayInputStream);
        if (xmlResourceBundle2.resourceMap.size() != xmlResourceBundle.resourceMap.size()) {
            throw new InternalError("Size mismatch!");
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        xmlResourceBundle.saveXml(byteArrayOutputStream);
        byteArrayOutputStream.close();
        System.out.println("=====================");
        System.out.println(new String(byteArrayOutputStream.toByteArray(), "utf-8"));
        Enumeration<String> enumeration = xmlResourceBundle2.getKeys();
        while (enumeration.hasMoreElements()) {
            Resource resource;
            String string = enumeration.nextElement();
            Resource resource2 = (Resource)xmlResourceBundle.resourceMap.get(string);
            if (resource2.equals(resource = (Resource)xmlResourceBundle2.resourceMap.get(string))) continue;
            throw new InternalError("Resource mismatch on key '" + string + "'!");
        }
        if (!Arrays.equals(byArray, byteArrayOutputStream.toByteArray())) {
            throw new InternalError("Output mismatch!");
        }
    }

    static {
        ValueType[] valueTypeArray = new ValueType[]{STRING_VALUE_TYPE, STRING_ARRAY_VALUE_TYPE, OBJECT_VALUE_TYPE};
        for (int i = valueTypeArray.length - 1; i >= 0; --i) {
            converterMapping.put(valueTypeArray[i].getTypeName(), valueTypeArray[i]);
        }
    }

    private class MyHandler
    extends DefaultHandler {
        private final Stack<ResourceGroup> groupStack = new Stack();
        private Resource pendingResource;
        private final StringBuilder pendingText = new StringBuilder();

        private MyHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (XmlResourceBundle.TAG_RESOURCE.equals(string3)) {
                this.pendingResource = new Resource(attributes);
                this.pendingText.setLength(0);
                this.groupStack.peek().addNode(this.pendingResource);
            } else if (XmlResourceBundle.TAG_ACTION.equals(string3)) {
                ResourceActionGroup resourceActionGroup = new ResourceActionGroup(attributes);
                this.groupStack.peek().addNode(resourceActionGroup);
                this.groupStack.push(resourceActionGroup);
            } else if (XmlResourceBundle.TAG_GROUP.equals(string3)) {
                ResourceGroup resourceGroup = new ResourceGroup(attributes);
                this.groupStack.peek().addNode(resourceGroup);
                this.groupStack.push(resourceGroup);
            } else if (XmlResourceBundle.TAG_I18N.equals(string3)) {
                XmlResourceBundle.this.root = new I18nGroup(attributes);
                String string4 = XmlResourceBundle.this.root.getVersion();
                if (string4 == null) {
                    throw new SAXException("No attribute version in <" + string3 + "> tag!");
                }
                try {
                    if (Integer.parseInt(string4) != 1) {
                        throw new SAXException("File format version mismatch: need 1 but have " + string4);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException("File format version mismatch: need 1 but have " + string4);
                }
                this.groupStack.push(XmlResourceBundle.this.root);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (XmlResourceBundle.TAG_RESOURCE.equals(string3)) {
                this.pendingResource.setValueFromString(this.pendingText.toString());
                XmlResourceBundle.this.resourceMap.put(this.pendingResource.getKey(), this.pendingResource);
                this.pendingResource = null;
            } else if (XmlResourceBundle.TAG_ACTION.equals(string3)) {
                this.groupStack.pop();
            } else if (XmlResourceBundle.TAG_GROUP.equals(string3)) {
                this.groupStack.pop();
            } else if (XmlResourceBundle.TAG_I18N.equals(string3)) {
                XmlResourceBundle.this.resourceMap.clear();
                XmlResourceBundle.this.root.registerResources(XmlResourceBundle.this.resourceMap);
                this.groupStack.pop();
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.pendingText.append(new String(cArray, n, n2));
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.pendingText.append(new String(cArray, n, n2));
        }
    }

    private static class Resource
    extends AbstractBasicResourceNode {
        private final String key;
        private Object value;
        private ValueType type;
        private boolean inhereted;

        private Resource(Attributes attributes) throws SAXException {
            super(attributes);
            String string = attributes.getValue(XmlResourceBundle.ATTR_KEY);
            if (string == null) {
                throw new SAXException("No attribute key in <res> tag!");
            }
            this.key = XmlResourceBundle.unescapeFromXml(string);
            String string2 = attributes.getValue(XmlResourceBundle.ATTR_INHERET);
            if (string2 != null) {
                this.inhereted = Boolean.valueOf(string2);
            }
            if (!this.inhereted) {
                String string3 = attributes.getValue(XmlResourceBundle.ATTR_TYPE);
                if (string3 == null) {
                    throw new SAXException("No attribute type in <res> tag!");
                }
                this.type = (ValueType)converterMapping.get(string3);
                if (this.type == null) {
                    throw new SAXException("Unknown value for type attribute in <res> tag: '" + string3 + "'!");
                }
            }
        }

        private Resource(String string, Object object, ValueType valueType, String string2) {
            super(string2);
            this.key = string;
            this.value = object;
            this.type = valueType;
        }

        private Resource(String string) {
            super((String)null);
            this.key = string;
            this.inhereted = true;
        }

        void setValue(Object object) {
            this.value = object;
        }

        void setValueFromString(String string) {
            if (!this.inhereted) {
                this.setValue(this.type.stringToValue(string));
            }
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public ValueType getConverter() {
            return this.type;
        }

        public boolean isInhereted() {
            return this.inhereted;
        }

        @Override
        protected void addXmlAttributes(StringBuilder stringBuilder) {
            XmlResourceBundle.addAttribute(stringBuilder, XmlResourceBundle.ATTR_KEY, XmlResourceBundle.escapeForXml(this.key));
            if (this.inhereted) {
                XmlResourceBundle.addAttribute(stringBuilder, XmlResourceBundle.ATTR_INHERET, "true");
            } else {
                XmlResourceBundle.addAttribute(stringBuilder, XmlResourceBundle.ATTR_TYPE, XmlResourceBundle.escapeForXml(this.type.getTypeName()));
            }
            super.addXmlAttributes(stringBuilder);
        }

        @Override
        protected void addXmlContent(StringBuilder stringBuilder) {
            if (!this.inhereted) {
                stringBuilder.append(this.type.valueToString(this.value));
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Resource resource = (Resource)object;
            return this.inhereted == resource.inhereted && (this.inhereted || Objects.equals(this.getComment(), resource.getComment()) && this.key.equals(resource.key) && this.type.equals(resource.type) && this.type.equals(this.value, resource.value));
        }

        public int hashCode() {
            return Objects.hash(this.value, this.type, this.getConverter(), this.inhereted);
        }

        @Override
        public ResourceNode[] getSubNodes() {
            return null;
        }

        @Override
        public void registerResources(Map<String, ResourceNode> map) {
            if (!this.inhereted) {
                map.put(this.key, this);
            }
        }

        @Override
        public String getXmlTag() {
            return XmlResourceBundle.TAG_RESOURCE;
        }

        @Override
        public String getId() {
            return this.key;
        }

        @Override
        protected boolean hasContent() {
            return !this.inhereted;
        }
    }

    private static class I18nGroup
    extends ResourceGroup {
        private final String version;

        private I18nGroup(Attributes attributes) {
            super(attributes);
            this.version = attributes.getValue(XmlResourceBundle.ATTR_VERSION);
        }

        private I18nGroup() {
            this.version = Integer.toString(1);
        }

        @Override
        protected void addXmlAttributes(StringBuilder stringBuilder) {
            super.addXmlAttributes(stringBuilder);
            XmlResourceBundle.addAttribute(stringBuilder, XmlResourceBundle.ATTR_VERSION, XmlResourceBundle.escapeForXml(this.version));
        }

        public String getVersion() {
            return this.version;
        }

        @Override
        public String getXmlTag() {
            return XmlResourceBundle.TAG_I18N;
        }
    }

    public static class ResourceActionGroup
    extends ResourceGroup {
        public static final String ACTION_GROUP_SUFFIX = "[ACTGRP]";
        private final String actionName;

        private ResourceActionGroup(Attributes attributes) {
            super(attributes);
            this.actionName = attributes.getValue(XmlResourceBundle.ATTR_NAME);
        }

        public ResourceActionGroup(String string) {
            this.actionName = string;
        }

        @Override
        public String getXmlTag() {
            return XmlResourceBundle.TAG_ACTION;
        }

        @Override
        protected void addXmlAttributes(StringBuilder stringBuilder) {
            super.addXmlAttributes(stringBuilder);
            XmlResourceBundle.addAttribute(stringBuilder, XmlResourceBundle.ATTR_NAME, this.actionName);
        }

        @Override
        public String getId() {
            return this.actionName;
        }

        static String getIdForSubGroup(String string) {
            int n;
            if (string != null && string.endsWith("[ACTION]") && (n = string.lastIndexOf(45, string.length() - "[ACTION]".length())) > 0) {
                String string2 = string.substring(0, n);
                return string2 + ACTION_GROUP_SUFFIX;
            }
            return null;
        }
    }

    private static class ResourceGroup
    extends AbstractBasicResourceNode {
        private final Map<String, ResourceNode> idsToResources = new HashMap<String, ResourceNode>();
        private final List<ResourceNode> nodes = new LinkedList<ResourceNode>();

        public ResourceGroup(Attributes attributes) {
            super(attributes);
        }

        protected ResourceGroup() {
            super((String)null);
        }

        public void addNode(ResourceNode resourceNode) {
            this.nodes.add(resourceNode);
            String string = resourceNode.getId();
            this.idsToResources.put(string, resourceNode);
        }

        @Override
        public ResourceNode[] getSubNodes() {
            return this.nodes.toArray(EMPTY_RESOURCE_NODE_ARRAY);
        }

        public ResourceNode getSubNode(String string) {
            return this.idsToResources.get(string);
        }

        @Override
        public void registerResources(Map<String, ResourceNode> map) {
            for (ResourceNode resourceNode : this.nodes) {
                resourceNode.registerResources(map);
            }
        }

        @Override
        protected void addXmlContent(StringBuilder stringBuilder) {
            stringBuilder.append("\n");
            for (ResourceNode resourceNode : this.nodes) {
                stringBuilder.append(resourceNode.toXml());
            }
        }

        @Override
        public String getXmlTag() {
            return XmlResourceBundle.TAG_GROUP;
        }

        @Override
        public String getId() {
            return null;
        }
    }

    public static abstract class AbstractBasicResourceNode
    implements ResourceNode {
        private String comment;

        protected AbstractBasicResourceNode(Attributes attributes) {
            this.comment = attributes.getValue(XmlResourceBundle.ATTR_COMMENT);
        }

        protected AbstractBasicResourceNode(String string) {
            this.comment = string;
        }

        @Override
        public String getComment() {
            return this.comment;
        }

        @Override
        public void setComment(String string) {
            this.comment = string;
        }

        protected void addXmlAttributes(StringBuilder stringBuilder) {
            if (this.comment != null) {
                XmlResourceBundle.addAttribute(stringBuilder, XmlResourceBundle.ATTR_COMMENT, this.comment);
            }
        }

        protected void addXmlCompleteTag(StringBuilder stringBuilder) {
            stringBuilder.append("<").append(this.getXmlTag());
            this.addXmlAttributes(stringBuilder);
            stringBuilder.append("/>\n");
        }

        protected void addXmlStartTag(StringBuilder stringBuilder) {
            stringBuilder.append("<").append(this.getXmlTag());
            this.addXmlAttributes(stringBuilder);
            stringBuilder.append(">");
        }

        protected void addXmlEndTag(StringBuilder stringBuilder) {
            stringBuilder.append("</").append(this.getXmlTag()).append(">\n");
        }

        protected void addXmlContent(StringBuilder stringBuilder) {
        }

        protected boolean hasContent() {
            return true;
        }

        @Override
        public String toXml() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.hasContent()) {
                this.addXmlStartTag(stringBuilder);
                this.addXmlContent(stringBuilder);
                this.addXmlEndTag(stringBuilder);
            } else {
                this.addXmlCompleteTag(stringBuilder);
            }
            return stringBuilder.toString();
        }
    }

    public static interface ResourceNode {
        public static final ResourceNode[] EMPTY_RESOURCE_NODE_ARRAY = new ResourceNode[0];

        public String getComment();

        public void setComment(String var1);

        public String toXml();

        public ResourceNode[] getSubNodes();

        public void registerResources(Map<String, ResourceNode> var1);

        public String getXmlTag();

        public String getId();
    }

    private static abstract class AbstractBasicValueType
    implements ValueType {
        private final String typeName;

        private AbstractBasicValueType(String string) {
            this.typeName = string;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }
    }

    public static interface ValueType {
        public String getTypeName();

        public String valueToString(Object var1);

        public Object stringToValue(String var1);

        public boolean equals(Object var1, Object var2);
    }
}

