/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.function.Consumer;

public class WeakReferencedLocalizable
implements Localizable {
    @NotNull
    private final WeakReference<Localizable> ref;
    @Nullable
    private final Consumer<? super Localizable> remover;

    public WeakReferencedLocalizable(@NotNull Localizable localizable) {
        this(localizable, I18n::removeLocalizationChangeListener);
    }

    public WeakReferencedLocalizable(@NotNull Localizable localizable, @Nullable Consumer<? super Localizable> consumer) {
        this.ref = new WeakReference<Localizable>(localizable);
        this.remover = consumer;
    }

    @Nullable
    private Localizable getWrapped() {
        Localizable localizable = (Localizable)this.ref.get();
        if (localizable == null && this.remover != null) {
            this.remover.accept(this);
        }
        return localizable;
    }

    @Override
    public void setLocale(Locale locale) {
        Localizable localizable = this.getWrapped();
        if (localizable != null) {
            localizable.setLocale(locale);
        }
    }

    @Override
    public Locale getLocale() {
        Localizable localizable = this.getWrapped();
        if (localizable != null) {
            return localizable.getLocale();
        }
        return null;
    }
}

