/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n;

import de.caff.annotation.NotNull;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class ResourceBundleCollection
extends ResourceBundle {
    private final Collection<ResourceBundle> resourceBundles = new LinkedList<ResourceBundle>();
    private Map<String, Object> resources = new HashMap<String, Object>();
    private final Locale locale;

    public ResourceBundleCollection(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void addResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundles.add(resourceBundle);
        this.addEntries(resourceBundle);
    }

    public void removeResourceBundle(ResourceBundle resourceBundle) {
        if (this.resourceBundles.remove(resourceBundle)) {
            this.resources = new HashMap<String, Object>();
            for (ResourceBundle resourceBundle2 : this.resourceBundles) {
                this.addEntries(resourceBundle2);
            }
        }
    }

    private void addEntries(ResourceBundle resourceBundle) {
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.resources.put(string, resourceBundle.getObject(string));
        }
    }

    void setParentBundle(ResourceBundle resourceBundle) {
        this.setParent(resourceBundle);
    }

    @Override
    protected Object handleGetObject(@NotNull String string) {
        return this.resources.get(string);
    }

    @Override
    @NotNull
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.resources.keySet());
    }
}

