/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.DefaultI18n;
import de.caff.i18n.Localizable;
import de.caff.util.Utility;
import de.caff.util.debug.Debug;
import java.awt.Image;
import java.io.PrintStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class I18n {
    static final boolean DEBUG = false;
    private static I18n i18n;
    private static final Object _LOCK;
    public static final String ACTION_SUFFIX = "[ACTION]";
    public static final String SUFFIX_TEXT = "-NAME[ACTION]";
    public static final String SUFFIX_TOOLTIP = "-TTT[ACTION]";
    public static final String SUFFIX_DESCRIPTION = "-DESCR[ACTION]";
    public static final String SUFFIX_ACCELERATOR = "-ACCEL[ACTION]";
    public static final String SUFFIX_MNEMONIC = "-MNEMO[ACTION]";
    public static final String SUFFIX_ICON = "-ICON[ACTION]";
    public static final String SUFFIX_DISABLED_ICON = "-ICON-DIS[ACTION]";
    public static final String SUFFIX_INACTIVE_ICON = "-ICON-INACT[ACTION]";

    public static void addAppResourceBase(@NotNull String string) {
        I18n.addAppResourceBase(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAppResourceBase(@NotNull String string, boolean bl) {
        if (i18n == null) {
            Object object = _LOCK;
            synchronized (object) {
                if (i18n == null) {
                    i18n = new DefaultI18n();
                }
            }
        }
        i18n._addAppResourceBase(string, bl);
    }

    protected abstract void _addAppResourceBase(@NotNull String var1, boolean var2);

    public static void setDefaultLocale(Locale locale) {
        i18n._setDefaultLocale(locale);
    }

    protected abstract void _setDefaultLocale(@Nullable Locale var1);

    @NotNull
    public static Locale getDefaultLocale() {
        return i18n._getDefaultLocale();
    }

    @NotNull
    protected abstract Locale _getDefaultLocale();

    protected abstract ResourceBundle _getFallbackBundle();

    private static ResourceBundle getBundle(@Nullable Locale locale) throws MissingResourceException {
        return i18n._getBundle(locale);
    }

    @NotNull
    protected abstract ResourceBundle _getBundle(@Nullable Locale var1) throws MissingResourceException;

    protected abstract void _dumpResources(@NotNull PrintStream var1, @Nullable Locale var2);

    public static void dump(@NotNull PrintStream printStream, @Nullable Locale locale) {
        i18n._dumpResources(printStream, locale);
    }

    @NotNull
    public static String getString(@NotNull String string) throws MissingResourceException {
        return I18n.getString(string, null);
    }

    @NotNull
    public static String getString(@NotNull String string, @Nullable Locale locale) throws MissingResourceException {
        if (locale == null) {
            locale = i18n._getDefaultLocale();
        }
        try {
            return I18n.getBundle(locale).getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return i18n._getFallbackBundle().getString(string);
        }
    }

    @NotNull
    public static String format(@NotNull String string, Object ... objectArray) throws MissingResourceException {
        return I18n.format(null, string, objectArray);
    }

    @NotNull
    public static String format(@Nullable Locale locale, @NotNull String string, Object ... objectArray) throws MissingResourceException {
        return Utility.compileString(string, objectArray, I18n.getBundle(locale));
    }

    @NotNull
    public static String getFormattedString(@NotNull String string, Object ... objectArray) throws MissingResourceException {
        return I18n.format(null, string, objectArray);
    }

    @NotNull
    public static String getFormattedString(@Nullable Locale locale, @NotNull String string, Object ... objectArray) throws MissingResourceException {
        return Utility.compileString(string, objectArray, I18n.getBundle(locale));
    }

    public static void addLocalizationChangeListener(@NotNull Localizable localizable) {
        i18n._addLocalizationChangeListener(localizable);
    }

    protected abstract void _addLocalizationChangeListener(@NotNull Localizable var1);

    public static void removeLocalizationChangeListener(@NotNull Localizable localizable) {
        i18n._removeLocalizationChangeListener(localizable);
    }

    protected abstract void _removeLocalizationChangeListener(@NotNull Localizable var1);

    protected abstract void _fireLocaleChanged(Locale var1);

    @Nullable
    public static Icon getIcon(@NotNull String string) {
        return I18n.getIcon(string, null);
    }

    @Nullable
    public static Icon getIcon(@NotNull String string, @Nullable Locale locale) {
        try {
            String string2 = I18n.getString(string, locale);
            Image image = Utility.loadImage(string2);
            if (image != null) {
                return new ImageIcon(image);
            }
        }
        catch (MissingResourceException missingResourceException) {
            Debug.warn(missingResourceException);
        }
        return null;
    }

    static {
        _LOCK = new Object();
    }
}

