/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Types;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.ResourceBundleCollection;
import de.caff.i18n.XmlResourceBundle;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DefaultI18n
extends I18n {
    private static final Locale FALLBACK_LOCALE = new Locale("", "", "");
    protected final Map<Locale, ResourceBundleCollection> resourceBundles = new HashMap<Locale, ResourceBundleCollection>();
    protected final List<String> appResourceBases = new LinkedList<String>();
    protected Locale defaultLocale = Locale.getDefault();
    protected final List<WeakReference<Localizable>> localizables = new ArrayList<WeakReference<Localizable>>();

    @Override
    protected synchronized void _addAppResourceBase(@NotNull String string, boolean bl) {
        if (!this.appResourceBases.contains(string)) {
            if (bl) {
                this.appResourceBases.add(0, string);
            } else {
                this.appResourceBases.add(string);
            }
            this.resourceBundles.clear();
        }
    }

    private ResourceBundle getFallbackResourceBundle(String string) {
        return XmlResourceBundle.getResourceBundle(string, null, this.getClass().getClassLoader());
    }

    @Override
    protected synchronized void _setDefaultLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.defaultLocale = locale;
        this.resourceBundles.clear();
        this._fireLocaleChanged(locale);
    }

    @Override
    @NotNull
    protected synchronized Locale _getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    @NotNull
    protected synchronized ResourceBundle _getBundle(@Nullable Locale locale) {
        ResourceBundle resourceBundle;
        if (locale == null) {
            locale = this.defaultLocale;
        }
        if ((resourceBundle = (ResourceBundle)this.resourceBundles.get(locale)) == null) {
            Locale locale2;
            ResourceBundle resourceBundle2;
            List<Locale> list;
            String string = locale.getLanguage();
            String string2 = locale.getCountry();
            String string3 = locale.getVariant();
            if (!FALLBACK_LOCALE.equals(locale)) {
                list = new ArrayList(4);
                if (!string3.isEmpty()) {
                    list.add(locale);
                }
                if (!string2.isEmpty()) {
                    list.add(list.isEmpty() ? locale : new Locale(string, string2, ""));
                }
                if (!string.isEmpty()) {
                    list.add(list.isEmpty() ? locale : new Locale(string, "", ""));
                }
                list.add(FALLBACK_LOCALE);
            } else {
                list = Types.asList((Object[])new Locale[]{FALLBACK_LOCALE});
            }
            ResourceBundleCollection resourceBundleCollection = null;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (resourceBundle2 = (ResourceBundle)this.resourceBundles.get(locale2 = (Locale)iterator.next())) == null) {
                if (this.appResourceBases.isEmpty()) {
                    throw new MissingResourceException("No application specific resource base defined", "<unknown>", "");
                }
                ResourceBundleCollection resourceBundleCollection2 = new ResourceBundleCollection(locale2);
                if (resourceBundleCollection != null) {
                    resourceBundleCollection.setParentBundle(resourceBundleCollection2);
                }
                for (String string4 : this.appResourceBases) {
                    try {
                        ResourceBundle resourceBundle3 = XmlResourceBundle.getResourceBundle(string4, locale2, this.getClass().getClassLoader());
                        if (!locale2.equals(resourceBundle3.getLocale())) continue;
                        resourceBundleCollection2.addResourceBundle(resourceBundle3);
                    }
                    catch (MissingResourceException missingResourceException) {}
                }
                this.resourceBundles.put(locale2, resourceBundleCollection2);
                resourceBundleCollection = resourceBundleCollection2;
            }
            resourceBundle = this.resourceBundles.get(locale);
        }
        return resourceBundle;
    }

    @Override
    protected synchronized ResourceBundle _getFallbackBundle() {
        return this._getBundle(FALLBACK_LOCALE);
    }

    @Override
    protected synchronized void _addLocalizationChangeListener(@NotNull Localizable localizable) {
        this.localizables.add(new WeakReference<Localizable>(localizable));
        localizable.setLocale(this._getDefaultLocale());
    }

    @Override
    protected synchronized void _removeLocalizationChangeListener(@NotNull Localizable localizable) {
        ListIterator<WeakReference<Localizable>> listIterator = this.localizables.listIterator();
        while (listIterator.hasNext()) {
            WeakReference<Localizable> weakReference = listIterator.next();
            if (localizable != weakReference.get()) continue;
            listIterator.remove();
            break;
        }
    }

    @Override
    protected synchronized void _fireLocaleChanged(Locale locale) {
        ListIterator<WeakReference<Localizable>> listIterator = this.localizables.listIterator();
        while (listIterator.hasNext()) {
            WeakReference<Localizable> weakReference = listIterator.next();
            Localizable localizable = (Localizable)weakReference.get();
            if (localizable != null) {
                localizable.setLocale(locale);
                continue;
            }
            listIterator.remove();
        }
    }

    @Override
    protected synchronized void _dumpResources(@NotNull PrintStream printStream, @Nullable Locale locale) {
        ResourceBundle resourceBundle = this._getBundle(locale);
        LinkedList<String> linkedList = new LinkedList<String>();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            linkedList.add(string);
        }
        Collections.sort(linkedList);
        printStream.println(String.format("Resource Dump for Locale [%s]", locale));
        for (String string : linkedList) {
            printStream.println(String.format("\"%s\":\t\"%s\"", string, resourceBundle.getObject(string)));
        }
    }
}

