/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.ui;

import de.caff.util.GlobMatcher;
import de.caff.util.debug.Debug;
import de.caff.util.ui.ArrayUIResourceHandler;
import de.caff.util.ui.BooleanUIResourceHandler;
import de.caff.util.ui.BorderUIResourceHandler;
import de.caff.util.ui.CharacterUIResourceHandler;
import de.caff.util.ui.ClassUIResourceHandler;
import de.caff.util.ui.ColorUIResourceHandler;
import de.caff.util.ui.DimensionUIResourceHandler;
import de.caff.util.ui.FloatUIResourceHandler;
import de.caff.util.ui.FontUIResourceHandler;
import de.caff.util.ui.GradientUIResourceHandler;
import de.caff.util.ui.InsetsUIResourceHandler;
import de.caff.util.ui.IntegerUIResourceHandler;
import de.caff.util.ui.ListUIResourceHandler;
import de.caff.util.ui.LongUIResourceHandler;
import de.caff.util.ui.MethodUIResourceHandler;
import de.caff.util.ui.StringUIResourceHandler;
import de.caff.util.ui.UIResourceHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class UIResourceCollection {
    private static final Set<String> warnedResources = new HashSet<String>();
    private final Map<String, Object> idsToKeys = new HashMap<String, Object>();
    private final Map<String, UIResourceHandler> resourceHandlers = new HashMap<String, UIResourceHandler>();
    private final UIDefaults defaults;
    private static final UIResourceHandlerCreator GRADIENT_UI_RESOURCE_HANDLER_CREATOR = GradientUIResourceHandler::new;
    private static final Map<Class<?>, UIResourceHandlerCreator> CREATOR_MAP = new HashMap();

    public UIResourceCollection() {
        this(UIManager.getDefaults());
    }

    private static UIResourceHandlerCreator getResourceHandlerCreator(Class<?> clazz) {
        UIResourceHandlerCreator uIResourceHandlerCreator;
        if (CREATOR_MAP.containsKey(clazz)) {
            return CREATOR_MAP.get(clazz);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = classArray.length - 1; i >= 0; --i) {
            uIResourceHandlerCreator = UIResourceCollection.getResourceHandlerCreator(classArray[i]);
            if (uIResourceHandlerCreator == null) continue;
            return uIResourceHandlerCreator;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (uIResourceHandlerCreator = UIResourceCollection.getResourceHandlerCreator(clazz2)) != null) {
            return uIResourceHandlerCreator;
        }
        return null;
    }

    private static Class<?> getCommonArrayElementClass(Object object) {
        Class<?> clazz = null;
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (object2 == null) continue;
            if (clazz == null) {
                clazz = object2.getClass();
                continue;
            }
            if (clazz == object2.getClass()) continue;
            clazz = null;
            break;
        }
        return clazz;
    }

    private static UIResourceHandlerCreator getResourceHandlerCreator(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            UIResourceHandlerCreator uIResourceHandlerCreator;
            Class<?> clazz2 = UIResourceCollection.getCommonArrayElementClass(object);
            if (clazz2 != null && (uIResourceHandlerCreator = UIResourceCollection.getResourceHandlerCreator(clazz2)) != null) {
                return new ArrayUIResourceHandlerCreator(uIResourceHandlerCreator);
            }
            return null;
        }
        if (object instanceof List) {
            Class<?> clazz3 = UIResourceCollection.getCommonArrayElementClass(((List)object).toArray());
            if (clazz3 != null) {
                UIResourceHandlerCreator uIResourceHandlerCreator = UIResourceCollection.getResourceHandlerCreator(clazz3);
                if (uIResourceHandlerCreator != null) {
                    return new ListUIResourceHandlerCreator(uIResourceHandlerCreator);
                }
            } else {
                List list = (List)object;
                if (list.size() == GradientUIResourceHandler.HELPER.length) {
                    boolean bl = true;
                    for (int i = 0; i < GradientUIResourceHandler.HELPER.length; ++i) {
                        Object e = list.get(i);
                        if (e != null && UIResourceCollection.isAssignable(i, e)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        return GRADIENT_UI_RESOURCE_HANDLER_CREATOR;
                    }
                }
            }
            return null;
        }
        return UIResourceCollection.getResourceHandlerCreator(clazz);
    }

    private static boolean isAssignable(int n, Object object) {
        return GradientUIResourceHandler.HELPER[n].getHandledClass().isAssignableFrom(object.getClass());
    }

    private static UIResourceHandler createResourceHandler(String string, Object object) {
        UIResourceHandlerCreator uIResourceHandlerCreator = UIResourceCollection.getResourceHandlerCreator(object);
        return uIResourceHandlerCreator != null ? uIResourceHandlerCreator.createHandler(string) : null;
    }

    public UIResourceCollection(UIDefaults uIDefaults) {
        this.defaults = uIDefaults;
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = uIDefaults.get(k);
            String string = k.toString();
            if (object != null) {
                this.idsToKeys.put(string, k);
                UIResourceHandler uIResourceHandler = UIResourceCollection.createResourceHandler(string, object);
                if (uIResourceHandler != null) {
                    this.resourceHandlers.put(string, uIResourceHandler);
                    continue;
                }
                String string2 = object.getClass().toString();
                if (warnedResources.contains(string2)) continue;
                warnedResources.add(string2);
                Debug.warn((String)"No handler for %0 (id: %1)", (Object[])new Object[]{string2, string});
                continue;
            }
            Debug.warn((String)("Cannot determine class for UI resource values with key " + k + ": null value"));
        }
    }

    public boolean setValue(String string, String string2) {
        UIResourceHandler uIResourceHandler = this.resourceHandlers.get(string);
        if (uIResourceHandler != null) {
            return uIResourceHandler.setValue(this, string2);
        }
        Debug.warn((String)("No resource handler for id " + string));
        return false;
    }

    public int setValues(String string, String string2) {
        int n = 0;
        GlobMatcher globMatcher = new GlobMatcher(string);
        for (String string3 : this.resourceHandlers.keySet()) {
            if (!globMatcher.isMatching(string3)) continue;
            if (this.setValue(string3, string2)) {
                Debug.trace((String)"Matching key '%0' set to '%1'", (Object[])new Object[]{string3, string2});
                ++n;
                continue;
            }
            Debug.warn((String)"Invalid value '%1' for key '%0'", (Object[])new Object[]{string3, string2});
        }
        return n;
    }

    public boolean hasHandler(String string) {
        return this.resourceHandlers.containsKey(string);
    }

    boolean setUIValue(String string, Object object) {
        Object object2 = this.idsToKeys.get(string);
        if (object2 == null) {
            Debug.warn((String)"No key for id %0", (Object[])new Object[]{string});
            return false;
        }
        this.defaults.put(object2, object);
        return true;
    }

    public static void main(String[] stringArray) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        TreeSet treeSet = new TreeSet((object, object2) -> {
            if (object == null) {
                return object2 == null ? 0 : -1;
            }
            if (object2 == null) {
                return 1;
            }
            return object.toString().compareTo(object2.toString());
        });
        Object object3 = uIDefaults.keys();
        while (object3.hasMoreElements()) {
            Object k = object3.nextElement();
            treeSet.add(k);
        }
        object3 = new UIResourceCollection(uIDefaults);
        System.out.println("<table>");
        System.out.println("<tr><th>Key</th><th>Class</th><th>Default Value</th></tr>");
        for (Object e : treeSet) {
            Object object4 = uIDefaults.get(e);
            if (((UIResourceCollection)object3).hasHandler(e.toString())) {
                System.out.print("<tr class=\"handled\">");
            } else {
                System.out.print("<tr class=\"unhandled\">");
            }
            System.out.print("<td>");
            System.out.print(e);
            System.out.print("</td>");
            System.out.print("<td>");
            UIResourceCollection.outputClass(object4);
            System.out.print("</td>");
            System.out.print("<td>");
            UIResourceCollection.outputValue(object4);
            System.out.print("</td>");
            System.out.println("</tr>");
        }
        System.out.println("</table>");
    }

    private static void outputValue(Object object) {
        if (object == null) {
            System.out.print("<null>");
        } else if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            System.out.print("[");
            System.out.print(n);
            System.out.print("]={");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    System.out.print(", ");
                }
                UIResourceCollection.outputValue(Array.get(object, i));
            }
            System.out.print("}");
        } else if (object instanceof List) {
            List list = (List)object;
            int n = list.size();
            System.out.print("[" + n + "]={");
            boolean bl = true;
            for (Object e : list) {
                if (bl) {
                    bl = false;
                } else {
                    System.out.print(", ");
                }
                UIResourceCollection.outputValue(e);
            }
            System.out.print("}");
        } else {
            System.out.print(object);
        }
    }

    private static void outputClass(Object object) {
        if (object == null) {
            System.out.print("???");
        } else {
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                int n = Array.getLength(object);
                System.out.print("Array[" + n + "]={");
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        System.out.print(", ");
                    }
                    UIResourceCollection.outputClass(Array.get(object, i));
                }
                System.out.print("}");
            } else if (object instanceof List) {
                List list = (List)object;
                int n = list.size();
                System.out.print("List[" + n + "]={");
                boolean bl = true;
                for (Object e : list) {
                    if (bl) {
                        bl = false;
                    } else {
                        System.out.print(", ");
                    }
                    UIResourceCollection.outputClass(e);
                }
                System.out.print("}");
            } else {
                System.out.print(clazz.getName());
            }
        }
    }

    static {
        CREATOR_MAP.put(Integer.class, IntegerUIResourceHandler::new);
        CREATOR_MAP.put(Long.class, LongUIResourceHandler::new);
        CREATOR_MAP.put(Color.class, ColorUIResourceHandler::new);
        CREATOR_MAP.put(Class.class, ClassUIResourceHandler::new);
        CREATOR_MAP.put(Method.class, MethodUIResourceHandler::new);
        CREATOR_MAP.put(Border.class, BorderUIResourceHandler::new);
        CREATOR_MAP.put(String.class, StringUIResourceHandler::new);
        CREATOR_MAP.put(Boolean.class, BooleanUIResourceHandler::new);
        CREATOR_MAP.put(Character.class, CharacterUIResourceHandler::new);
        CREATOR_MAP.put(Font.class, FontUIResourceHandler::new);
        CREATOR_MAP.put(Insets.class, InsetsUIResourceHandler::new);
        CREATOR_MAP.put(Dimension.class, DimensionUIResourceHandler::new);
        CREATOR_MAP.put(Float.class, FloatUIResourceHandler::new);
    }

    private static class ListUIResourceHandlerCreator
    implements UIResourceHandlerCreator {
        private final UIResourceHandlerCreator subCreator;

        private ListUIResourceHandlerCreator(UIResourceHandlerCreator uIResourceHandlerCreator) {
            this.subCreator = uIResourceHandlerCreator;
        }

        @Override
        public UIResourceHandler createHandler(String string) {
            return new ListUIResourceHandler(string, this.subCreator.createHandler("[]"));
        }
    }

    private static class ArrayUIResourceHandlerCreator
    implements UIResourceHandlerCreator {
        private final UIResourceHandlerCreator subCreator;

        private ArrayUIResourceHandlerCreator(UIResourceHandlerCreator uIResourceHandlerCreator) {
            this.subCreator = uIResourceHandlerCreator;
        }

        @Override
        public UIResourceHandler createHandler(String string) {
            return new ArrayUIResourceHandler(string, this.subCreator.createHandler("[]"));
        }
    }

    private static interface UIResourceHandlerCreator {
        public UIResourceHandler createHandler(String var1);
    }
}

