/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.ui;

import de.caff.util.debug.Debug;
import de.caff.util.ui.UIResourceHandler;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public class MethodUIResourceHandler
extends UIResourceHandler {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(",");

    public MethodUIResourceHandler(String string) {
        super(string);
    }

    @Override
    protected Object toValue(String string) {
        int n;
        int n2;
        int n3 = string.indexOf(40);
        int n4 = string.indexOf(41);
        if (n3 > 0 && n4 > n3 && (n2 = string.lastIndexOf(32, n3)) > 0 && (n = string.lastIndexOf(46, n3)) > n2) {
            try {
                Class[] classArray;
                Class<?> clazz = Class.forName(string.substring(n2 + 1, n));
                if (n3 + 1 == n4) {
                    classArray = new Class[]{};
                } else {
                    String[] stringArray = SEPARATOR_PATTERN.split(string.substring(n3 + 1, n4));
                    classArray = new Class[stringArray.length];
                    for (int i = stringArray.length - 1; i >= 0; --i) {
                        classArray[i] = Class.forName(stringArray[i]);
                    }
                }
                return clazz.getMethod(string.substring(n + 1, n3), classArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.error((Throwable)classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Debug.error((Throwable)noSuchMethodException);
            }
        }
        return null;
    }

    @Override
    protected String fromValue(Object object) {
        if (object != null) {
            try {
                Method method = (Method)object;
                StringBuilder stringBuilder = new StringBuilder(method.getName());
                stringBuilder.append("(");
                Class<?>[] classArray = method.getParameterTypes();
                for (int i = 0; i < classArray.length; ++i) {
                    stringBuilder.append(MethodUIResourceHandler.getTypeName(classArray[i]));
                    if (i >= classArray.length - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            catch (Exception exception) {
                Debug.error((Throwable)exception);
            }
        }
        return super.fromValue(object);
    }

    @Override
    public Class<?> getHandledClass() {
        return Method.class;
    }

    private static String getTypeName(Class<?> clazz) {
        if (clazz.isArray()) {
            try {
                Class<?> clazz2 = clazz;
                int n = 0;
                while (clazz2.isArray()) {
                    ++n;
                    clazz2 = clazz2.getComponentType();
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(clazz2.getName());
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append("[]");
                }
                return stringBuilder.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return clazz.getName();
    }
}

