/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.ui;

import de.caff.util.debug.Debug;
import de.caff.util.ui.UIResourceHandler;
import java.awt.Insets;
import java.util.regex.Pattern;
import javax.swing.plaf.InsetsUIResource;

public class InsetsUIResourceHandler
extends UIResourceHandler {
    private static final Pattern PATTERN_COMMA = Pattern.compile(",");

    public InsetsUIResourceHandler(String string) {
        super(string);
    }

    @Override
    protected Object toValue(String string) {
        String[] stringArray = PATTERN_COMMA.split(string);
        if (stringArray.length == 4) {
            try {
                int n = Integer.parseInt(stringArray[0].trim());
                int n2 = Integer.parseInt(stringArray[1].trim());
                int n3 = Integer.parseInt(stringArray[2].trim());
                int n4 = Integer.parseInt(stringArray[3].trim());
                return new InsetsUIResource(n, n2, n3, n4);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.error((Throwable)numberFormatException);
            }
        }
        return null;
    }

    @Override
    protected String fromValue(Object object) {
        Insets insets = (Insets)object;
        if (insets != null) {
            return Integer.toString(insets.top) + "," + insets.left + "," + insets.bottom + "," + insets.right;
        }
        return null;
    }

    @Override
    public Class<?> getHandledClass() {
        return Insets.class;
    }
}

