/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.ui;

import de.caff.util.debug.Debug;
import de.caff.util.ui.ColorUIResourceHandler;
import de.caff.util.ui.FloatUIResourceHandler;
import de.caff.util.ui.UIResourceHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class GradientUIResourceHandler
extends UIResourceHandler {
    private static final FloatUIResourceHandler FLOAT_HELPER = new FloatUIResourceHandler("foo");
    private static final ColorUIResourceHandler COLOR_HELPER = new ColorUIResourceHandler("bar");
    static final UIResourceHandler[] HELPER = new UIResourceHandler[]{FLOAT_HELPER, COLOR_HELPER, COLOR_HELPER};
    private static final Pattern PATTERN_COMMA = Pattern.compile(",");

    public GradientUIResourceHandler(String string) {
        super(string);
    }

    @Override
    protected Object toValue(String string) {
        String[] stringArray = PATTERN_COMMA.split(string);
        if (stringArray.length == HELPER.length) {
            ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                Object object = HELPER[i].toValue(stringArray[i]);
                if (object == null) {
                    return null;
                }
                arrayList.add(object);
            }
            return arrayList;
        }
        Debug.error((String)"Not %0 elements in gradient definition: %1", (Object[])new Object[]{HELPER.length, string});
        return null;
    }

    @Override
    protected String fromValue(Object object) {
        if (object != null) {
            try {
                List list = (List)object;
                if (list.size() == HELPER.length) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < HELPER.length; ++i) {
                        String string = HELPER[i].fromValue(list.get(i));
                        if (string == null) {
                            return null;
                        }
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(string);
                    }
                    return stringBuilder.toString();
                }
            }
            catch (ClassCastException classCastException) {
                Debug.error((Throwable)classCastException);
            }
        }
        return null;
    }

    @Override
    public Class<?> getHandledClass() {
        return List.class;
    }
}

