/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.ui;

import de.caff.util.debug.Debug;
import de.caff.util.ui.UIResourceHandler;
import java.awt.Dimension;
import java.util.regex.Pattern;
import javax.swing.plaf.DimensionUIResource;

public class DimensionUIResourceHandler
extends UIResourceHandler {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");

    public DimensionUIResourceHandler(String string) {
        super(string);
    }

    @Override
    protected Object toValue(String string) {
        String[] stringArray = COMMA_PATTERN.split(string);
        if (stringArray.length == 2) {
            try {
                int n = Integer.parseInt(stringArray[0].trim());
                int n2 = Integer.parseInt(stringArray[1].trim());
                return new DimensionUIResource(n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.error((Throwable)numberFormatException);
            }
        }
        return null;
    }

    @Override
    protected String fromValue(Object object) {
        Dimension dimension = (Dimension)object;
        if (dimension != null) {
            return Integer.toString(dimension.width) + "," + dimension.height;
        }
        return null;
    }

    @Override
    public Class<?> getHandledClass() {
        return Dimension.class;
    }
}

