/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.ui;

import de.caff.util.ColorDecoder;
import de.caff.util.debug.Debug;
import de.caff.util.ui.UIResourceHandler;
import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

public class ColorUIResourceHandler
extends UIResourceHandler {
    private static final String COLOR_FORMAT = "#%02x%02x%02x";

    public ColorUIResourceHandler(String string) {
        super(string);
    }

    @Override
    protected String fromValue(Object object) {
        try {
            Color color = (Color)object;
            if (color != null) {
                return String.format(COLOR_FORMAT, color.getRed(), color.getGreen(), color.getBlue());
            }
        }
        catch (ClassCastException classCastException) {
            Debug.error((Throwable)classCastException);
        }
        return null;
    }

    @Override
    protected Object toValue(String string) {
        Color color = ColorDecoder.decode((String)string.trim());
        return color != null ? new ColorUIResource(color) : null;
    }

    @Override
    public Class<?> getHandledClass() {
        return Color.class;
    }
}

