/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.ui;

import de.caff.generics.Empty;
import de.caff.i18n.I18n;
import de.caff.util.ColorDecoder;
import de.caff.util.debug.Debug;
import de.caff.util.ui.UIResourceHandler;
import java.awt.Color;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.MissingResourceException;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;

public class BorderUIResourceHandler
extends UIResourceHandler {
    public BorderUIResourceHandler(String string) {
        super(string);
    }

    @Override
    protected Object toValue(String string) {
        try {
            Border border = BorderUIResourceHandler.createBorder(string);
            return border != null ? new BorderUIResource(border) : null;
        }
        catch (ParseException parseException) {
            Debug.error((Throwable)parseException);
            return null;
        }
    }

    @Override
    protected String fromValue(Object object) {
        try {
            Border border = (Border)object;
            if (border != null) {
                return border.toString();
            }
        }
        catch (ClassCastException classCastException) {
            Debug.error((Throwable)classCastException);
        }
        return null;
    }

    private static String[] getArguments(String string) throws ParseException {
        if ((string = string.trim()).charAt(0) != '(') {
            throw new ParseException("Not a valid argument list: " + string, 0);
        }
        if (string.charAt(string.length() - 1) != ')') {
            throw new ParseException("Not a valid argument list: " + string, string.length() - 1);
        }
        string = string.substring(1, string.length() - 1);
        LinkedList<String> linkedList = new LinkedList<String>();
        if (!string.isEmpty()) {
            string = string + ',';
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            block6: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (bl) {
                    if (c != '\'') continue;
                    bl = false;
                    continue;
                }
                switch (c) {
                    case '\'': {
                        bl = true;
                        continue block6;
                    }
                    case '(': {
                        ++n;
                        continue block6;
                    }
                    case ')': {
                        if (--n >= 0) continue block6;
                        throw new ParseException("Too many closing parenthesis in " + string.substring(0, string.length() - 1), i);
                    }
                    case ',': {
                        if (n != 0) continue block6;
                        String string2 = string.substring(n2, i).trim();
                        if (string2.length() >= 2 && string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'') {
                            string2 = string2.substring(1, string2.length() - 1);
                        }
                        linkedList.add(string2);
                        n2 = i + 1;
                    }
                }
            }
            if (n != 0) {
                throw new ParseException("Unbalanced parenthesis in " + string.substring(0, string.length() - 1), string.length() - 1);
            }
            if (bl) {
                throw new ParseException("Unbalanced ' in " + string.substring(0, string.length() - 1), string.length() - 1);
            }
        }
        return linkedList.toArray(Empty.STRING_ARRAY);
    }

    private static int getInt(String string) throws ParseException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Not an integer number: " + string, string.length() - 1);
        }
    }

    private static Color parseColor(String string) throws ParseException {
        Color color = ColorDecoder.decode((String)string);
        if (color == null) {
            throw new ParseException("Cannot decode color value: " + string, 0);
        }
        return color;
    }

    private static String resolveI18n(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("${") && string.endsWith("}")) {
            try {
                return I18n.getString((String)string.substring(2, string.length() - 1));
            }
            catch (MissingResourceException missingResourceException) {
                Debug.error((String)("Cannot resolve tag '" + string + "'"));
                return string.substring(2, string.length() - 1);
            }
        }
        return string;
    }

    public static Border createBorder(String string) throws ParseException {
        String string2 = string.toLowerCase();
        if (string2.startsWith("bevel(")) {
            int n;
            String[] stringArray = BorderUIResourceHandler.getArguments(string.substring(5));
            if ("lowered".equalsIgnoreCase(stringArray[0])) {
                n = 1;
            } else if ("raised".equalsIgnoreCase(stringArray[0])) {
                n = 0;
            } else {
                throw new ParseException("Not a valid bevel type: " + stringArray[0], 5);
            }
            switch (stringArray.length) {
                case 1: {
                    return BorderFactory.createBevelBorder(n);
                }
                case 3: {
                    return BorderFactory.createBevelBorder(n, BorderUIResourceHandler.parseColor(stringArray[1]), BorderUIResourceHandler.parseColor(stringArray[2]));
                }
                case 5: {
                    return BorderFactory.createBevelBorder(n, BorderUIResourceHandler.parseColor(stringArray[1]), BorderUIResourceHandler.parseColor(stringArray[2]), BorderUIResourceHandler.parseColor(stringArray[3]), BorderUIResourceHandler.parseColor(stringArray[4]));
                }
            }
            throw new ParseException("Not a valid number of color parameters for bevel border: " + string, 5);
        }
        if (string2.startsWith("compound(")) {
            String[] stringArray = BorderUIResourceHandler.getArguments(string.substring(8));
            switch (stringArray.length) {
                case 0: {
                    return BorderFactory.createCompoundBorder();
                }
                case 2: {
                    return BorderFactory.createCompoundBorder(BorderUIResourceHandler.createBorder(stringArray[0]), BorderUIResourceHandler.createBorder(stringArray[1]));
                }
            }
            throw new ParseException("Not a valid number of parameters for compound border: " + string, 8);
        }
        if (string2.startsWith("empty(")) {
            String[] stringArray = BorderUIResourceHandler.getArguments(string.substring(5));
            switch (stringArray.length) {
                case 0: {
                    return BorderFactory.createEmptyBorder();
                }
                case 4: {
                    return BorderFactory.createEmptyBorder(BorderUIResourceHandler.getInt(stringArray[0]), BorderUIResourceHandler.getInt(stringArray[1]), BorderUIResourceHandler.getInt(stringArray[2]), BorderUIResourceHandler.getInt(stringArray[3]));
                }
            }
            throw new ParseException("Not a valid number of parameters for empty border: " + string, 5);
        }
        if (string2.startsWith("etched(")) {
            int n;
            String[] stringArray = BorderUIResourceHandler.getArguments(string.substring(6));
            if (stringArray.length == 0) {
                return BorderFactory.createEtchedBorder();
            }
            if (stringArray.length == 2) {
                return BorderFactory.createEtchedBorder(BorderUIResourceHandler.parseColor(stringArray[0]), BorderUIResourceHandler.parseColor(stringArray[1]));
            }
            if ("lowered".equalsIgnoreCase(stringArray[0])) {
                n = 1;
            } else if ("raised".equalsIgnoreCase(stringArray[0])) {
                n = 0;
            } else {
                throw new ParseException("Not a valid etched type: " + stringArray[0], 6);
            }
            switch (stringArray.length) {
                case 1: {
                    return BorderFactory.createEtchedBorder(n);
                }
                case 3: {
                    return BorderFactory.createEtchedBorder(n, BorderUIResourceHandler.parseColor(stringArray[0]), BorderUIResourceHandler.parseColor(stringArray[1]));
                }
            }
            throw new ParseException("Not a valid number of parameters for etched border: " + string, 6);
        }
        if (string2.startsWith("line(")) {
            String[] stringArray = BorderUIResourceHandler.getArguments(string.substring(4));
            switch (stringArray.length) {
                case 1: {
                    return BorderFactory.createLineBorder(BorderUIResourceHandler.parseColor(stringArray[0]));
                }
                case 2: {
                    return BorderFactory.createLineBorder(BorderUIResourceHandler.parseColor(stringArray[0]), BorderUIResourceHandler.getInt(stringArray[1]));
                }
            }
            throw new ParseException("Not a valid number of parameters for empty border: " + string, 4);
        }
        if (string2.startsWith("loweredbevel(")) {
            String[] stringArray = BorderUIResourceHandler.getArguments(string.substring(12));
            switch (stringArray.length) {
                case 0: {
                    return BorderFactory.createLoweredBevelBorder();
                }
            }
            throw new ParseException("Not a valid number of parameters for loweredBevel border: " + string, 12);
        }
        if (string2.startsWith("matte(")) {
            String[] stringArray = BorderUIResourceHandler.getArguments(string.substring(5));
            switch (stringArray.length) {
                case 5: {
                    return BorderFactory.createMatteBorder(BorderUIResourceHandler.getInt(stringArray[0]), BorderUIResourceHandler.getInt(stringArray[1]), BorderUIResourceHandler.getInt(stringArray[2]), BorderUIResourceHandler.getInt(stringArray[3]), BorderUIResourceHandler.parseColor(stringArray[4]));
                }
            }
            throw new ParseException("Not a valid number of parameters for matte border: " + string, 5);
        }
        if (string2.startsWith("raisedbevel(")) {
            String[] stringArray = BorderUIResourceHandler.getArguments(string.substring(11));
            switch (stringArray.length) {
                case 0: {
                    return BorderFactory.createRaisedBevelBorder();
                }
            }
            throw new ParseException("Not a valid number of parameters for raisedBevel border: " + string, 11);
        }
        if (string2.startsWith("titled(")) {
            String[] stringArray = BorderUIResourceHandler.getArguments(string.substring(6));
            switch (stringArray.length) {
                case 1: {
                    return BorderFactory.createTitledBorder(BorderUIResourceHandler.resolveI18n(stringArray[0]));
                }
                case 2: {
                    return BorderFactory.createTitledBorder(BorderUIResourceHandler.createBorder(stringArray[0]), BorderUIResourceHandler.resolveI18n(stringArray[1]));
                }
                case 4: {
                    int n;
                    int n2;
                    if ("left".equalsIgnoreCase(stringArray[2])) {
                        n2 = 1;
                    } else if ("right".equalsIgnoreCase(stringArray[2])) {
                        n2 = 3;
                    } else if ("center".equalsIgnoreCase(stringArray[2])) {
                        n2 = 2;
                    } else if ("leading".equalsIgnoreCase(stringArray[2])) {
                        n2 = 4;
                    } else if ("trailing".equalsIgnoreCase(stringArray[2])) {
                        n2 = 5;
                    } else if ("default".equalsIgnoreCase(stringArray[2])) {
                        n2 = 0;
                    } else {
                        throw new ParseException("Not a valid justification type on titled border: " + stringArray[2], 0);
                    }
                    if ("above_top".equalsIgnoreCase(stringArray[3])) {
                        n = 1;
                    } else if ("top".equalsIgnoreCase(stringArray[3])) {
                        n = 2;
                    } else if ("below_top".equalsIgnoreCase(stringArray[3])) {
                        n = 3;
                    } else if ("above_bottom".equalsIgnoreCase(stringArray[3])) {
                        n = 4;
                    } else if ("bottom".equalsIgnoreCase(stringArray[3])) {
                        n = 5;
                    } else if ("below_bottom".equalsIgnoreCase(stringArray[3])) {
                        n = 6;
                    } else if ("default".equalsIgnoreCase(stringArray[3])) {
                        n = 0;
                    } else {
                        throw new ParseException("Not a valid position type on titled border: " + stringArray[3], 0);
                    }
                    return BorderFactory.createTitledBorder(BorderUIResourceHandler.createBorder(stringArray[0]), BorderUIResourceHandler.resolveI18n(stringArray[1]), n2, n);
                }
            }
            throw new ParseException("Not a valid number of parameters for titled border: " + string, 6);
        }
        throw new ParseException("Unknown border type: " + string, 0);
    }

    @Override
    public Class<?> getHandledClass() {
        return Border.class;
    }
}

