/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.ui;

import de.caff.util.debug.Debug;
import de.caff.util.ui.UIResourceHandler;
import java.util.LinkedList;
import java.util.List;

public class ArrayUIResourceHandler
extends UIResourceHandler {
    protected static final char MARKER = '@';
    protected static final String MARKER_STRING = Character.toString('@');
    protected static final String ARRAY_START = MARKER_STRING + "[@";
    protected static final String ARRAY_END = MARKER_STRING + "]@";
    protected static final String ELEMENT_SEPARATOR = MARKER_STRING + "|@";
    protected final UIResourceHandler elementHandler;

    public ArrayUIResourceHandler(String string, UIResourceHandler uIResourceHandler) {
        super(string);
        this.elementHandler = uIResourceHandler;
    }

    @Override
    protected Object toValue(String string) {
        List<String> list = ArrayUIResourceHandler.split(string);
        if (list != null) {
            Object[] objectArray = new Object[list.size()];
            int n = 0;
            for (String string2 : list) {
                objectArray[n] = this.elementHandler.toValue(string2);
                if (objectArray[n] == null) {
                    return null;
                }
                ++n;
            }
            return objectArray;
        }
        return null;
    }

    protected static List<String> split(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (!(string = string.trim()).startsWith(ARRAY_START)) {
            Debug.error((String)"Array not starting with %0", (Object[])new Object[]{ARRAY_START});
            return null;
        }
        if (!string.endsWith(ARRAY_END)) {
            Debug.error((String)"Array not ending with %0", (Object[])new Object[]{ARRAY_END});
            return null;
        }
        String string2 = string.substring(ARRAY_START.length(), string.length() - ARRAY_END.length());
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        while (n < n3) {
            char c = string2.charAt(n);
            if (c == '@') {
                String string3 = string2.substring(n);
                if (n2 == 0 && string3.startsWith(ELEMENT_SEPARATOR)) {
                    linkedList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    n += ELEMENT_SEPARATOR.length();
                    continue;
                }
                if (string3.startsWith(ARRAY_START)) {
                    ++n2;
                    stringBuilder.append(ARRAY_START);
                    n += ARRAY_START.length();
                    continue;
                }
                if (!string3.startsWith(ARRAY_END)) continue;
                if (--n2 < 0) {
                    Debug.error((String)"Too many closing %0 for array!", (Object[])new Object[]{ARRAY_END});
                    return null;
                }
                stringBuilder.append(ARRAY_END);
                n += ARRAY_END.length();
                continue;
            }
            stringBuilder.append(c);
        }
        if (!linkedList.isEmpty() || stringBuilder.length() > 0) {
            linkedList.add(stringBuilder.toString());
        }
        return linkedList;
    }

    @Override
    protected String fromValue(Object object) {
        if (object != null) {
            Object[] objectArray = (Object[])object;
            StringBuilder stringBuilder = new StringBuilder(ARRAY_START);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(ELEMENT_SEPARATOR);
                }
                stringBuilder.append(this.elementHandler.fromValue(objectArray[i]));
            }
            stringBuilder.append(ARRAY_END);
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    public Class<?> getHandledClass() {
        return Object[].class;
    }
}

