/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.table;

import de.caff.annotation.Nullable;
import de.caff.util.table.AbstractBasicPropertyResolver;
import de.caff.util.table.FieldBasedPropertyResolver;
import de.caff.util.table.MethodBasedPropertyResolver;
import de.caff.util.table.PropertyResolveException;
import de.caff.util.table.PropertyResolver;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ReadOnlyPropertyTableModel
extends AbstractTableModel {
    public static final int COLUMN_INDEX_NAME = 0;
    public static final int COLUMN_INDEX_VALUE = 1;
    private static final long serialVersionUID = -1212470710766192947L;
    private final List<PropertyResolver> resolvers;
    private final Object object;

    public ReadOnlyPropertyTableModel(@Nullable Object object) {
        this.object = object;
        LinkedList<AbstractBasicPropertyResolver> linkedList = new LinkedList<AbstractBasicPropertyResolver>();
        if (object != null) {
            Class<?> clazz = object.getClass();
            for (Field accessibleObject : clazz.getFields()) {
                if (Modifier.isStatic(accessibleObject.getModifiers()) || !FieldBasedPropertyResolver.isProperty(accessibleObject)) continue;
                linkedList.add(new FieldBasedPropertyResolver(accessibleObject));
            }
            for (AccessibleObject accessibleObject : clazz.getMethods()) {
                if (Modifier.isStatic(((Method)accessibleObject).getModifiers()) || !MethodBasedPropertyResolver.isProperty((Method)accessibleObject)) continue;
                linkedList.add(new MethodBasedPropertyResolver((Method)accessibleObject));
            }
        }
        this.resolvers = new ArrayList<PropertyResolver>(linkedList);
    }

    @Override
    public int getRowCount() {
        return this.resolvers.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PropertyResolver propertyResolver = this.resolvers.get(n);
        switch (n2) {
            case 0: {
                return propertyResolver.getPropertyName();
            }
            case 1: {
                try {
                    return propertyResolver.getPropertyValue(this.object);
                }
                catch (PropertyResolveException propertyResolveException) {
                    return propertyResolveException;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Property Name";
            }
            case 1: {
                return "Property Value";
            }
        }
        return null;
    }

    public void update() {
        this.fireTableDataChanged();
    }
}

