/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.table;

import de.caff.annotation.NotNull;
import de.caff.util.table.AbstractBasicPropertyResolver;
import de.caff.util.table.PropertyHide;
import de.caff.util.table.PropertyName;
import de.caff.util.table.PropertyResolveException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class MethodBasedPropertyResolver
extends AbstractBasicPropertyResolver {
    static final String METHOD_PREFIX_GET = "get";
    static final String METHOD_PREFIX_IS = "is";
    private final Method method;

    public MethodBasedPropertyResolver(Method method) {
        super(MethodBasedPropertyResolver.getPropertyNameFromMethod(method));
        this.method = method;
    }

    static String getPropertyNameFromMethod(Method method) {
        PropertyName propertyName = method.getAnnotation(PropertyName.class);
        if (propertyName != null) {
            return propertyName.value();
        }
        String string = method.getName();
        if (string.startsWith(METHOD_PREFIX_GET)) {
            return string.substring(METHOD_PREFIX_GET.length());
        }
        if (string.startsWith(METHOD_PREFIX_IS)) {
            return string.substring(METHOD_PREFIX_IS.length());
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(Character.toUpperCase(string.charAt(0)));
        stringBuilder.append(string.substring(1));
        return stringBuilder.toString();
    }

    static boolean isProperty(@NotNull Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        Class<?> clazz = method.getReturnType();
        if (clazz == null) {
            return false;
        }
        if (method.getAnnotation(PropertyHide.class) != null) {
            return false;
        }
        String string = method.getName();
        if (string.startsWith(METHOD_PREFIX_GET) && string.length() > METHOD_PREFIX_GET.length()) {
            return true;
        }
        return string.startsWith(METHOD_PREFIX_IS) && string.length() > METHOD_PREFIX_IS.length() && clazz.equals(Boolean.TYPE);
    }

    @Override
    public Object getPropertyValue(Object object) throws PropertyResolveException {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new PropertyResolveException(throwable);
        }
    }
}

