/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.table;

import de.caff.annotation.NotNull;
import de.caff.util.table.AbstractBasicPropertyResolver;
import de.caff.util.table.PropertyHide;
import de.caff.util.table.PropertyName;
import de.caff.util.table.PropertyResolveException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

class FieldBasedPropertyResolver
extends AbstractBasicPropertyResolver {
    @NotNull
    private final Field field;

    public FieldBasedPropertyResolver(@NotNull Field field) {
        super(FieldBasedPropertyResolver.getPropertyNameFromField(field));
        this.field = field;
    }

    static String getPropertyNameFromField(@NotNull Field field) {
        PropertyName propertyName = field.getAnnotation(PropertyName.class);
        if (propertyName != null) {
            return propertyName.value();
        }
        String string = field.getName();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(Character.toUpperCase(string.charAt(0)));
        stringBuilder.append(string.substring(1));
        return stringBuilder.toString();
    }

    static boolean isProperty(@NotNull Field field) {
        if (!Modifier.isPublic(field.getModifiers())) {
            return false;
        }
        return field.getAnnotation(PropertyHide.class) == null;
    }

    @Override
    public Object getPropertyValue(Object object) throws PropertyResolveException {
        try {
            return this.field.get(object);
        }
        catch (Throwable throwable) {
            throw new PropertyResolveException(throwable);
        }
    }
}

