/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.table;

import de.caff.annotation.NotNull;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AutoAdjustRowHeightTable
extends JTable {
    private static final long serialVersionUID = -954724048773141856L;
    private boolean autoAdjustingPerRow = false;

    public AutoAdjustRowHeightTable() {
    }

    public AutoAdjustRowHeightTable(TableModel tableModel) {
        super(tableModel);
    }

    public AutoAdjustRowHeightTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
    }

    public AutoAdjustRowHeightTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
    }

    public AutoAdjustRowHeightTable(int n, int n2) {
        super(n, n2);
    }

    public AutoAdjustRowHeightTable(Vector<? extends Vector<?>> vector, Vector<?> vector2) {
        super(vector, vector2);
    }

    public AutoAdjustRowHeightTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
    }

    @Override
    public void setModel(@NotNull TableModel tableModel) {
        super.setModel(tableModel);
        this.adjustRowHeights();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        this.adjustRowHeights();
    }

    public boolean isAutoAdjustingPerRow() {
        return this.autoAdjustingPerRow;
    }

    public void setAutoAdjustingPerRow(boolean bl) {
        this.autoAdjustingPerRow = bl;
    }

    public void adjustRowHeightsPerRow() {
        int n = this.getRowMargin();
        int n2 = this.getRowHeight();
        if (n2 == 0) {
            return;
        }
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            int n3 = n2;
            for (int j = this.getColumnCount() - 1; j >= 0; --j) {
                Component component = this.prepareRenderer(this.getCellRenderer(i, j), i, j);
                n3 = Math.max(n3, component.getPreferredSize().height);
            }
            this.setRowHeight(i, n3 + n);
        }
    }

    public void adjustRowHeightCompletely() {
        int n = this.getRowHeight();
        if (n == 0) {
            return;
        }
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            for (int j = this.getColumnCount() - 1; j >= 0; --j) {
                Component component = this.prepareRenderer(this.getCellRenderer(i, j), i, j);
                n = Math.max(n, component.getPreferredSize().height);
            }
        }
        this.setRowHeight(n);
    }

    public void adjustRowHeights() {
        if (this.autoAdjustingPerRow) {
            this.adjustRowHeightsPerRow();
        } else {
            this.adjustRowHeightCompletely();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.adjustRowHeights();
    }
}

