/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Countable;
import de.caff.generics.Dict;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.Pair;
import de.caff.generics.Types;
import de.caff.util.Utility;
import de.caff.util.debug.Debug;
import de.caff.vic.DynamicallyScaledIcon;
import de.caff.vic.SimpleVectorImageReader;
import de.caff.vic.VectorImage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import java.net.URL;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.function.Consumer;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.JTableHeader;

public class SwingHelper {
    private static final Component[] EMPTY_COMPONENT_ARRAY = new Component[0];
    public static final int DEFAULT_MIN_FONT_SIZE = 5;
    public static final IntIndexable STANDARD_ICON_SIZES = IntIndexable.viewArray((int[])new int[]{16, 24, 32, 48, 64, 72, 96, 128, 180, 256});
    private static final String DEFAULT_ICON_LOAD_CLASS = Utility.getStringParameter((String)"default.icon.loader", (String)"de.caff.gimmicks.resources.IconConstants");
    public static final int DEFAULT_NUM_ROWS = 96;
    private static final int DEFAULT_RELATIVE_FONT_SIZE = 128;
    private static int accumulatedFontSizeChanges = 0;
    public static final Dict<RenderingHints.Key, Object> DEFAULT_RENDER;
    public static final Dict<RenderingHints.Key, Object> NICE_RENDER;
    public static final Dict<RenderingHints.Key, Object> FAST_RENDER;

    public static void adjustFontSizes(int n) {
        SwingHelper.adjustFontSizes(n, 5);
    }

    public static void adjustFontSizes(int n, int n2) {
        SwingHelper.adjustFontSizes(n, n2, EMPTY_COMPONENT_ARRAY);
    }

    public static void adjustFontSizes(int n, @Nullable Component component) {
        SwingHelper.adjustFontSizes(n, 5, component);
    }

    public static void adjustFontSizes(int n, int n2, @Nullable Component component) {
        Component[] componentArray;
        if (component != null) {
            Component[] componentArray2 = new Component[1];
            componentArray = componentArray2;
            componentArray2[0] = component;
        } else {
            componentArray = EMPTY_COMPONENT_ARRAY;
        }
        SwingHelper.adjustFontSizes(n, n2, componentArray);
    }

    public static void adjustFontSizes(int n, Component ... componentArray) {
        SwingHelper.adjustFontSizes(n, 5, componentArray);
    }

    public static void adjustFontSizes(int n, int n2, Component ... componentArray) {
        Iterable<?> iterable;
        if (n == 0) {
            return;
        }
        int n3 = SwingHelper.getMinUiFontSize();
        if (n < 0 && n3 + n < n2) {
            if (n3 == n2) {
                return;
            }
            n = n2 - n3;
        }
        if (n == 0) {
            return;
        }
        Debug.message((String)"Adjusting font sizes: %0", (Object[])new Object[]{n});
        accumulatedFontSizeChanges += n;
        float f = 1.0f + (float)n / (float)n3;
        int n4 = 10;
        while (true) {
            try {
                iterable = SwingHelper.getUniqueUIKeys();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                Debug.error((Throwable)concurrentModificationException);
                if (--n4 > 0) continue;
                Debug.error((String)"Too many retries for setting font size! Giving up!");
                return;
            }
            break;
        }
        for (Object obj : iterable) {
            Object object = UIManager.get(obj);
            if (!(object instanceof Font)) continue;
            Font serializable = (Font)object;
            float f2 = serializable.getSize2D();
            float f3 = f2 * f;
            UIManager.put(obj, new FontUIResource(serializable.deriveFont(f3)));
        }
        for (Component component : componentArray) {
            SwingHelper.updateUI(component);
        }
    }

    @NotNull
    private static Iterable<?> getUniqueUIKeys() {
        return Types.map(new TreeSet(), UIManager.getDefaults().keys(), String::valueOf);
    }

    public static int getMinUiFontSize() {
        int n = Integer.MAX_VALUE;
        for (Object obj : SwingHelper.getUniqueUIKeys()) {
            Font font;
            int n2;
            Object object = UIManager.get(obj);
            if (!(object instanceof Font) || (n2 = (font = (Font)object).getSize()) >= n) continue;
            n = n2;
        }
        return n;
    }

    public static void updateUI(Component component) {
        SwingHelper.afterEachJComponent(component, JComponent::updateUI);
    }

    private static void beforeEachJComponent(@Nullable Component component, @NotNull Consumer<JComponent> consumer) {
        SwingHelper.forEachJComponent(component, consumer, true, false);
    }

    private static void afterEachJComponent(@Nullable Component component, @NotNull Consumer<JComponent> consumer) {
        SwingHelper.forEachJComponent(component, consumer, false, true);
    }

    private static void forEachJComponent(@Nullable Component component, @NotNull Consumer<JComponent> consumer, boolean bl, boolean bl2) {
        if (component instanceof Container) {
            Container container = (Container)component;
            if (bl && container instanceof JComponent) {
                consumer.accept((JComponent)container);
            }
            for (int i = container.getComponentCount() - 1; i >= 0; --i) {
                SwingHelper.forEachJComponent(container.getComponent(i), consumer, bl, bl2);
            }
            if (component instanceof JMenu) {
                JMenu jMenu = (JMenu)component;
                for (int i = jMenu.getItemCount() - 1; i >= 0; --i) {
                    SwingHelper.forEachJComponent(jMenu.getItem(i), consumer, bl, bl2);
                }
            }
            if (bl2 && container instanceof JComponent) {
                consumer.accept((JComponent)container);
            }
        }
    }

    public static int getAccumulatedFontSizeChanges() {
        return accumulatedFontSizeChanges;
    }

    public static void enableHiDpiSupport(@NotNull Window window, Component ... componentArray) {
        Component[] componentArray2 = window.getComponents();
        Component[] componentArray3 = new Component[componentArray2.length + componentArray.length];
        System.arraycopy(componentArray2, 0, componentArray3, 0, componentArray2.length);
        System.arraycopy(componentArray, 0, componentArray3, componentArray2.length, componentArray.length);
        MouseWheelListener mouseWheelListener = mouseWheelEvent -> {
            int n;
            if ((mouseWheelEvent.getModifiersEx() & 0x80) != 0 && (n = mouseWheelEvent.getWheelRotation()) != 0) {
                SwingHelper.adjustFontSizes(n, componentArray3);
                for (Component component : componentArray3) {
                    SwingHelper.updateUI(component);
                }
            }
        };
        for (Component component : componentArray3) {
            component.addMouseWheelListener(mouseWheelListener);
        }
    }

    public static int setupDefaultHiDpi() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return SwingHelper.setupDefaultHiDpi(graphicsConfiguration);
    }

    public static int setupDefaultHiDpi(@NotNull GraphicsConfiguration graphicsConfiguration) {
        int n = SwingHelper.getMinUiFontSize();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        int n2 = (int)Math.round(rectangle.getHeight() / (double)n / 128.0);
        if (n2 > 1) {
            int n3 = n * (n2 - 1);
            Debug.message((String)"Initial setup: %0", (Object[])new Object[]{n3});
            SwingHelper.adjustFontSizes(n3);
            return n3;
        }
        return 0;
    }

    public static int getUsefulFontSize() {
        return SwingHelper.getUsefulFontSize(96);
    }

    public static int getUsefulFontSize(int n) {
        return SwingHelper.getUsefulFontSize(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration(), n);
    }

    public static int getUsefulFontSize(@NotNull GraphicsConfiguration graphicsConfiguration) {
        return SwingHelper.getUsefulFontSize(graphicsConfiguration, 96);
    }

    public static int getUsefulFontSize(@NotNull GraphicsConfiguration graphicsConfiguration, int n) {
        Rectangle rectangle = graphicsConfiguration.getBounds();
        return (int)Math.round(3.0 * rectangle.getHeight() / (double)(4 * n));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Icon loadIconResource(@NotNull String string) {
        if (!string.toLowerCase().endsWith(".vic")) {
            Image image = Utility.loadImage((String)string);
            if (image == null) return null;
            return new ImageIcon(image);
        }
        try {
            URL uRL;
            if (string.indexOf(124) < 0) {
                string = DEFAULT_ICON_LOAD_CLASS + "|" + string;
            }
            if ((uRL = Utility.openResourceViaClass((String)string)) == null) {
                Debug.error((String)"Resource unavailable: %s", (Object[])new Object[]{string});
                return null;
            }
            try (InputStream inputStream = uRL.openStream();){
                VectorImage vectorImage = SimpleVectorImageReader.loadImage((InputStream)inputStream);
                DynamicallyScaledIcon dynamicallyScaledIcon = new DynamicallyScaledIcon(vectorImage, "ToolBar.font", 1.3333333333333333);
                return dynamicallyScaledIcon;
            }
        }
        catch (Exception exception) {
            Debug.error((Throwable)exception);
            return null;
        }
    }

    @NotNull
    public static Rectangle getDrawableViewport(@NotNull Component component) {
        return component instanceof JComponent ? SwingHelper.getDrawableViewport((JComponent)component) : new Rectangle(component.getSize());
    }

    @NotNull
    public static Rectangle getDrawableViewport(@NotNull JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        int n = jComponent.getWidth();
        int n2 = jComponent.getHeight();
        return new Rectangle(insets.left, insets.top, n - insets.left - insets.right, n2 - insets.top - insets.bottom);
    }

    @NotNull
    public static AffineTransform fitTransform(@NotNull Rectangle2D rectangle2D, @NotNull Rectangle2D rectangle2D2, double d) {
        return SwingHelper.fitTransform(rectangle2D, rectangle2D2, d, false);
    }

    @NotNull
    public static AffineTransform fitTransform(@NotNull Rectangle2D rectangle2D, @NotNull Rectangle2D rectangle2D2, double d, boolean bl) {
        return SwingHelper.fitTransform(rectangle2D, rectangle2D2, d, bl, true);
    }

    @NotNull
    public static AffineTransform fitTransform(@NotNull Rectangle2D rectangle2D, @NotNull Rectangle2D rectangle2D2, double d, boolean bl, boolean bl2) {
        double d2;
        double d3;
        if (bl2) {
            d2 = d3 = Math.min((rectangle2D2.getWidth() - 2.0 * d) / rectangle2D.getWidth(), (rectangle2D2.getHeight() - 2.0 * d) / rectangle2D.getHeight());
        } else {
            d2 = (rectangle2D2.getWidth() - 2.0 * d) / rectangle2D.getWidth();
            d3 = (rectangle2D2.getHeight() - 2.0 * d) / rectangle2D.getHeight();
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.concatenate(AffineTransform.getTranslateInstance(rectangle2D2.getCenterX(), rectangle2D2.getCenterY()));
        affineTransform.concatenate(AffineTransform.getScaleInstance(d2, bl ? -d3 : d3));
        affineTransform.concatenate(AffineTransform.getTranslateInstance(-rectangle2D.getCenterX(), -rectangle2D.getCenterY()));
        return affineTransform;
    }

    @NotNull
    public static AffineTransform viewTransform(@NotNull Rectangle2D rectangle2D, @NotNull JComponent jComponent, double d) {
        return SwingHelper.viewTransform(rectangle2D, jComponent, d, false);
    }

    @NotNull
    public static AffineTransform viewTransform(@NotNull Rectangle2D rectangle2D, @NotNull JComponent jComponent, double d, boolean bl) {
        return SwingHelper.viewTransform(rectangle2D, jComponent, d, bl, true);
    }

    @NotNull
    public static AffineTransform viewTransform(@NotNull Rectangle2D rectangle2D, @NotNull JComponent jComponent, double d, boolean bl, boolean bl2) {
        return SwingHelper.fitTransform(rectangle2D, SwingHelper.getDrawableViewport(jComponent), d, bl, bl2);
    }

    public static int getModifiersExWithButton(@NotNull MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        switch (mouseEvent.getButton()) {
            case 1: {
                n |= 0x400;
                break;
            }
            case 2: {
                n |= 0x800;
                break;
            }
            case 3: {
                n |= 0x1000;
            }
        }
        return n;
    }

    public static void invokeMuchLater(@NotNull Runnable runnable) {
        SwingHelper.invokeMuchLater(8, runnable);
    }

    public static void invokeMuchLater(final int n, final @NotNull Runnable runnable) {
        if (n <= 1) {
            SwingUtilities.invokeLater(runnable);
        }
        Runnable runnable2 = new Runnable(){
            int counter;
            {
                this.counter = n;
            }

            @Override
            public void run() {
                if (--this.counter > 0) {
                    SwingUtilities.invokeLater(this);
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        };
        SwingUtilities.invokeLater(runnable2);
    }

    @NotNull
    public static Rectangle getScreenViewport(@NotNull GraphicsConfiguration graphicsConfiguration) {
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    public static void prepareGraphics(@NotNull Graphics2D graphics2D, @NotNull Dict<RenderingHints.Key, ?> dict) {
        dict.forEachEntry(graphics2D::setRenderingHint);
    }

    public static void prepareDefaultGraphics(@NotNull Graphics2D graphics2D) {
        SwingHelper.prepareGraphics(graphics2D, DEFAULT_RENDER);
    }

    public static void prepareNiceGraphics(@NotNull Graphics2D graphics2D) {
        SwingHelper.prepareGraphics(graphics2D, NICE_RENDER);
    }

    public static void prepareFastGraphics(@NotNull Graphics2D graphics2D) {
        SwingHelper.prepareGraphics(graphics2D, FAST_RENDER);
    }

    @NotNull
    public static JPanel simpleTwoColumnPanel(JComponent ... jComponentArray) {
        if (jComponentArray.length % 2 != 0) {
            throw new IllegalArgumentException("Need an even number of components!");
        }
        return SwingHelper.simpleTwoColumnPanel((Iterable<Pair<JComponent>>)Indexable.viewByIndex((int)(jComponentArray.length / 2), n -> Pair.createPair((Object)jComponentArray[2 * n], (Object)jComponentArray[2 * n + 1])));
    }

    @NotNull
    public static JPanel simpleTwoColumnPanelFrom(@NotNull Indexable<? extends JComponent> indexable) {
        if (indexable.size() % 2 != 0) {
            throw new IllegalArgumentException("Need an even number of components!");
        }
        return SwingHelper.simpleTwoColumnPanel((Iterable<Pair<JComponent>>)Indexable.viewByIndex((int)(indexable.size() / 2), n -> Pair.createPair((Object)indexable.get(2 * n), (Object)indexable.get(2 * n + 1))));
    }

    @NotNull
    public static JPanel simpleTwoColumnPanel(@NotNull Iterable<Pair<JComponent>> iterable) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        SwingHelper.setupSimpleTwoColumnPanel(jPanel, iterable);
        return jPanel;
    }

    public static void setupSimpleTwoColumnPanel(@NotNull JPanel jPanel, @NotNull Iterable<Pair<JComponent>> iterable) {
        GridBagLayout gridBagLayout;
        try {
            gridBagLayout = (GridBagLayout)jPanel.getLayout();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Panel is expected to have a grid bag layout!", classCastException);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(6, 4, 6, 4);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        for (Pair<JComponent> pair : iterable) {
            Component component = (Component)Types.notNullOr((Object)pair.first, JLabel::new);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagLayout.setConstraints(component, gridBagConstraints);
            jPanel.add(component);
            Component component2 = (Component)Types.notNullOr((Object)pair.second, JLabel::new);
            ++gridBagConstraints.gridx;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(component2, gridBagConstraints);
            jPanel.add(component2);
            ++gridBagConstraints.gridy;
        }
    }

    @NotNull
    public static JPanel simpleMultiColumnPanel(int n, JComponent ... jComponentArray) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        SwingHelper.setupSimpleMultiColumnPanel(jPanel, n, jComponentArray);
        return jPanel;
    }

    public static void setupSimpleMultiColumnPanel(@NotNull JPanel jPanel, int n, JComponent ... jComponentArray) {
        SwingHelper.setupSimpleMultiColumnPanel(jPanel, n, (Countable<? extends JComponent>)Countable.viewArray((Object[])jComponentArray));
    }

    @NotNull
    public static JPanel createSimpleMultiColumnPanel(int n, @NotNull Countable<? extends JComponent> countable) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        SwingHelper.setupSimpleMultiColumnPanel(jPanel, n, countable);
        return jPanel;
    }

    public static void setupSimpleMultiColumnPanel(@NotNull JPanel jPanel, int n, @NotNull Countable<? extends JComponent> countable) {
        GridBagLayout gridBagLayout;
        try {
            gridBagLayout = (GridBagLayout)jPanel.getLayout();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Panel is expected to have a grid bag layout!", classCastException);
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Need at least one column, but got " + n);
        }
        if (countable.size() % n != 0) {
            throw new IllegalArgumentException(String.format("Number of components (%d) is not a multiple of number of columns (%d)!", countable.size(), n));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(6, 4, 6, 4);
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 2;
        int n2 = 0;
        for (JComponent jComponent2 : countable.view(jComponent -> (JComponent)Types.notNullOr((Object)jComponent, JLabel::new))) {
            int n3;
            gridBagConstraints.gridx = n3 = n2 % n;
            if (n3 == n - 1) {
                gridBagConstraints.gridwidth = 0;
            } else {
                if (n3 == 0) {
                    ++gridBagConstraints.gridy;
                }
                gridBagConstraints.gridwidth = 1;
            }
            gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
            jPanel.add(jComponent2);
            ++n2;
        }
    }

    @NotNull
    public static JFrame simpleApplicationFrame(@NotNull String string, @NotNull JComponent jComponent, int n, int n2) {
        JFrame jFrame = new JFrame(string);
        jFrame.getContentPane().add(jComponent);
        jFrame.setDefaultCloseOperation(2);
        if (n <= 0 || n2 <= 0) {
            jFrame.pack();
        } else {
            jFrame.setSize(n, n2);
        }
        return jFrame;
    }

    @NotNull
    public static JFrame showSimpleApplicationFrame(@NotNull String string, @NotNull JComponent jComponent, int n, int n2) {
        JFrame jFrame = SwingHelper.simpleApplicationFrame(string, jComponent, n, n2);
        jFrame.setVisible(true);
        return jFrame;
    }

    @NotNull
    public static JList<String> buildRowHeader(@NotNull JTable jTable, final @NotNull Vector<String> vector) {
        AbstractListModel<String> abstractListModel = new AbstractListModel<String>(){
            private static final long serialVersionUID = -772559910860527115L;

            @Override
            public int getSize() {
                return vector.size();
            }

            @Override
            public String getElementAt(int n) {
                return (String)vector.get(n);
            }
        };
        JList<String> jList = new JList<String>(abstractListModel);
        jList.setOpaque(false);
        RowHeaderRenderer rowHeaderRenderer = new RowHeaderRenderer(jTable);
        int n = 0;
        int n2 = 0;
        for (String string : vector) {
            Component component = rowHeaderRenderer.getListCellRendererComponent(jList, string, n2++, false, false);
            n = Math.max(component.getPreferredSize().width, n);
        }
        jList.setPreferredSize(new Dimension(n, jList.getPreferredSize().height));
        jList.setCellRenderer(rowHeaderRenderer);
        jList.setBackground(jTable.getBackground());
        jList.setForeground(jTable.getForeground());
        return jList;
    }

    static {
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        HashMap<RenderingHints.Key, Object> hashMap2 = new HashMap<RenderingHints.Key, Object>();
        HashMap<RenderingHints.Key, Object> hashMap3 = new HashMap<RenderingHints.Key, Object>();
        hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        hashMap2.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hashMap3.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        hashMap2.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hashMap3.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        hashMap2.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        hashMap3.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        hashMap2.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hashMap3.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        hashMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        hashMap2.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        hashMap3.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        hashMap.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
        hashMap2.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        hashMap3.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        hashMap.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT);
        hashMap2.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        hashMap3.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        DEFAULT_RENDER = Dict.viewMap(hashMap);
        NICE_RENDER = Dict.viewMap(hashMap2);
        FAST_RENDER = Dict.viewMap(hashMap3);
    }

    static class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        private static final long serialVersionUID = -8065593795296883073L;
        private final JTable table;

        RowHeaderRenderer(@NotNull JTable jTable) {
            this.table = jTable;
            JTableHeader jTableHeader = this.table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("TableHeader.cellBorder"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this.setHorizontalAlignment(0);
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setFont(jTableHeader.getFont());
            this.setDoubleBuffered(true);
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> jList, String string, int n, boolean bl, boolean bl2) {
            this.setText(Types.notNull((String)string));
            this.setPreferredSize(null);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.table.getRowHeight(n)));
            jList.repaint();
            return this;
        }
    }
}

