/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Indexable;
import de.caff.gimmicks.swing.ResourcedAction;
import de.caff.i18n.swing.RJButton;
import de.caff.i18n.swing.RJPanel;
import de.caff.util.debug.Debug;
import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingUrlListPreferenceProperty;
import de.caff.util.swing.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;

class UrlListEditor
extends AbstractBasicEditorProvider {
    private final SwingUrlListPreferenceProperty property;
    private final JPanel panel;
    private final JList<String> list;
    @Nullable
    private final List<String> startList;
    private final SwingUrlListPreferenceProperty.UrlSelectionMode urlSelectionMode;
    private final Action add = new ResourcedAction("tbAdd"){
        private static final long serialVersionUID = 55118404268663770L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Component component = SwingUtilities.getRoot(UrlListEditor.this.panel);
            UrlDialog urlDialog = component instanceof Dialog ? new UrlDialog((Dialog)component, null, UrlListEditor.this.urlSelectionMode) : (component instanceof Frame ? new UrlDialog((Frame)component, null, UrlListEditor.this.urlSelectionMode) : new UrlDialog(null, UrlListEditor.this.urlSelectionMode));
            urlDialog.setVisible(true);
            String string = urlDialog.getUrl();
            if (string != null) {
                UrlListEditor.this.getModel().addElement(string);
            }
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    };
    private final Action delete = new ResourcedAction("tbDelete"){
        private static final long serialVersionUID = -6218395420075667584L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UrlListEditor.this.getModel().removeElementAt(UrlListEditor.this.list.getSelectedIndex());
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    };
    private final Action change = new ResourcedAction("tbChange"){
        private static final long serialVersionUID = -4153188207958211070L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Component component = SwingUtilities.getRoot(UrlListEditor.this.panel);
            UrlDialog urlDialog = component instanceof Dialog ? new UrlDialog((Dialog)component, (String)UrlListEditor.this.list.getSelectedValue(), UrlListEditor.this.urlSelectionMode) : (component instanceof Frame ? new UrlDialog((Frame)component, (String)UrlListEditor.this.list.getSelectedValue(), UrlListEditor.this.urlSelectionMode) : new UrlDialog((String)UrlListEditor.this.list.getSelectedValue(), UrlListEditor.this.urlSelectionMode));
            urlDialog.setVisible(true);
            String string = urlDialog.getUrl();
            if (string != null) {
                UrlListEditor.this.getModel().setElementAt(string, UrlListEditor.this.list.getSelectedIndex());
            }
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    };
    private final Action up = new ResourcedAction("tbUp"){
        private static final long serialVersionUID = 8893706601703876660L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = UrlListEditor.this.list.getSelectedIndex();
            UrlListEditor.this.swap(n, n - 1);
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    };
    private final Action down = new ResourcedAction("tbDown"){
        private static final long serialVersionUID = -6479486919655281546L;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = UrlListEditor.this.list.getSelectedIndex();
            UrlListEditor.this.swap(n, n + 11);
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    };

    private DefaultListModel<String> getModel() {
        return (DefaultListModel)this.list.getModel();
    }

    public UrlListEditor(final @NotNull SwingUrlListPreferenceProperty swingUrlListPreferenceProperty, Locale locale, @NotNull SwingUrlListPreferenceProperty.UrlSelectionMode urlSelectionMode, Action ... actionArray) {
        super(swingUrlListPreferenceProperty, locale);
        this.property = swingUrlListPreferenceProperty;
        this.startList = new ArrayList<String>(swingUrlListPreferenceProperty.getUrlList());
        Indexable<String> indexable = swingUrlListPreferenceProperty.getDefaults();
        int n = SwingHelper.getUsefulFontSize();
        this.panel = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.add(new JButton(this.add));
        jPanel.add(new JButton(this.delete));
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(new JButton(this.change));
        jPanel.add(Box.createVerticalStrut(n));
        jPanel.add(new JButton(this.up));
        jPanel.add(new JButton(this.down));
        if (indexable != null) {
            jPanel.add(Box.createVerticalStrut(n));
            ResourcedAction object = new ResourcedAction("tbResetToDefaults"){
                private static final long serialVersionUID = -3427781287206689984L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Indexable<String> indexable = swingUrlListPreferenceProperty.getDefaults();
                    assert (indexable != null);
                    DefaultListModel defaultListModel = UrlListEditor.this.getModel();
                    defaultListModel.removeAllElements();
                    indexable.forEach(defaultListModel::addElement);
                }
            };
            jPanel.add(new JButton(object));
        }
        if (actionArray.length > 0) {
            jPanel.add(Box.createVerticalStrut(n));
            for (Action action : actionArray) {
                jPanel.add(new JButton(action));
            }
        }
        this.panel.add((Component)jPanel, "East");
        this.list = new JList<String>(UrlListEditor.createListModel(swingUrlListPreferenceProperty.getUrlList()));
        this.panel.add((Component)new JScrollPane(this.list), "Center");
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(listSelectionEvent -> this.enableButtons(listSelectionEvent.getFirstIndex()));
        this.enableButtons(this.list.getSelectedIndex());
        this.urlSelectionMode = urlSelectionMode;
    }

    @NotNull
    protected static DefaultListModel<String> createListModel(@NotNull Collection<String> collection) {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : collection) {
            defaultListModel.addElement(string);
        }
        return defaultListModel;
    }

    public void addListSelectionListener(@NotNull ListSelectionListener listSelectionListener) {
        this.list.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(@NotNull ListSelectionListener listSelectionListener) {
        this.list.removeListSelectionListener(listSelectionListener);
    }

    private void swap(int n, int n2) {
        DefaultListModel<String> defaultListModel = this.getModel();
        String string = defaultListModel.getElementAt(n);
        String string2 = defaultListModel.getElementAt(n2);
        defaultListModel.setElementAt(string, n2);
        defaultListModel.setElementAt(string2, n);
    }

    private void enableButtons(int n) {
        if (n < 0) {
            this.delete.setEnabled(false);
            this.change.setEnabled(false);
            this.up.setEnabled(false);
            this.down.setEnabled(false);
        } else {
            this.delete.setEnabled(true);
            this.change.setEnabled(true);
            this.up.setEnabled(n > 0);
            this.down.setEnabled(n < this.list.getModel().getSize() - 1);
        }
    }

    @Override
    @NotNull
    public JComponent getEditor() {
        return this.panel;
    }

    @Override
    public void reset() {
        DefaultListModel<String> defaultListModel = this.getModel();
        defaultListModel.removeAllElements();
        for (String string : this.property.getUrlList()) {
            defaultListModel.addElement(string);
        }
    }

    @Override
    public void save() {
        DefaultListModel<String> defaultListModel = this.getModel();
        Object[] objectArray = defaultListModel.toArray();
        ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
        for (Object object : objectArray) {
            arrayList.add(object.toString());
        }
        this.property.setUrlList(arrayList);
    }

    @Override
    public void goodBye() {
    }

    @NotNull
    private static URL fileToUrl(@NotNull File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    private class UrlDialog
    extends JDialog {
        private static final long serialVersionUID = -915106342148489332L;
        private JTextField urlField;
        private JButton ok;
        private String result;

        UrlDialog(@Nullable Dialog dialog, @NotNull String string, SwingUrlListPreferenceProperty.UrlSelectionMode urlSelectionMode) {
            super(dialog);
            this.init(string, urlSelectionMode);
            this.setLocationRelativeTo(dialog);
        }

        UrlDialog(@Nullable Frame frame, @NotNull String string, SwingUrlListPreferenceProperty.UrlSelectionMode urlSelectionMode) {
            super(frame);
            this.init(string, urlSelectionMode);
            this.setLocationRelativeTo(frame);
        }

        UrlDialog(@NotNull String string, SwingUrlListPreferenceProperty.UrlSelectionMode urlSelectionMode) {
            this.init(string, urlSelectionMode);
        }

        private void init(String string, @NotNull SwingUrlListPreferenceProperty.UrlSelectionMode urlSelectionMode) {
            this.setModal(true);
            this.setDefaultCloseOperation(2);
            this.setTitle(UrlListEditor.this.property.getDialogTitle());
            this.urlField = new JTextField(string == null ? "" : string, 80);
            JButton jButton = UrlListEditor.this.property.getDialogButton();
            RJPanel rJPanel = new RJPanel(new BorderLayout());
            rJPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), BorderFactory.createEtchedBorder()));
            this.ok = new RJButton("Ok");
            RJButton rJButton = new RJButton("Cancel");
            Box box = Box.createHorizontalBox();
            this.getContentPane().setLayout(new BorderLayout());
            rJPanel.add((Component)UrlListEditor.this.property.getDialogLabel(), "West");
            rJPanel.add((Component)this.urlField, "Center");
            rJPanel.add((Component)jButton, "East");
            box.add(Box.createHorizontalGlue());
            box.add(this.ok);
            box.add(rJButton);
            box.add(Box.createHorizontalGlue());
            this.getContentPane().add((Component)rJPanel, "North");
            this.getContentPane().add((Component)box, "South");
            jButton.addActionListener(actionEvent -> {
                File file;
                File file2 = this.extractFile();
                JFileChooser jFileChooser = new JFileChooser(file2);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setFileSelectionMode(urlSelectionMode.getFileSelectionMode());
                jFileChooser.setFileFilter(UrlListEditor.this.property.getDialogFileFilter());
                if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    try {
                        this.urlField.setText(UrlListEditor.fileToUrl(file).toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        Debug.error((Throwable)malformedURLException);
                    }
                }
            });
            this.urlField.addCaretListener(caretEvent -> this.checkUrl());
            this.ok.addActionListener(actionEvent -> {
                try {
                    this.result = this.extractURL().toString();
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.error((String)"Okay button should not be active!");
                }
                this.dispose();
            });
            rJButton.addActionListener(actionEvent -> this.dispose());
            this.checkUrl();
            this.pack();
        }

        @NotNull
        private URL extractURL() throws MalformedURLException {
            String string = this.urlField.getText().trim();
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                File file = new File(string);
                if (file.exists() && UrlListEditor.this.urlSelectionMode.isAllowed(file)) {
                    return file.toURI().toURL();
                }
                throw malformedURLException;
            }
        }

        @NotNull
        private File extractFile() {
            String string = this.urlField.getText().trim();
            if (string.startsWith("file:")) {
                try {
                    URL uRL = this.extractURL();
                    string = uRL.getPath();
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.error((Throwable)malformedURLException);
                }
            }
            return new File(string);
        }

        private void checkUrl() {
            try {
                this.extractURL();
                this.ok.setEnabled(true);
                this.urlField.setBackground(Color.white);
            }
            catch (MalformedURLException malformedURLException) {
                this.ok.setEnabled(false);
                this.urlField.setBackground(new Color(255, 192, 192));
            }
        }

        public String getUrl() {
            return this.result;
        }
    }
}

