/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.gimmicks.swing.PropagateEnableScrollPane;
import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingTextProperty;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class TextEditor
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private final SwingTextProperty property;
    private final JTextArea textArea;

    public TextEditor(@NotNull SwingTextProperty swingTextProperty, boolean bl, Locale locale) {
        super(swingTextProperty, locale);
        this.property = swingTextProperty;
        this.textArea = new JTextArea(swingTextProperty.getValue(), swingTextProperty.getRows(), swingTextProperty.getColumns());
        swingTextProperty.addValueChangeListenerWeakly(this);
        if (bl) {
            this.textArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    TextEditor.this.saveLater();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    TextEditor.this.saveLater();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    TextEditor.this.saveLater();
                }
            });
        }
        this.textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TextEditor.this.textArea.selectAll();
            }
        });
    }

    @Override
    @NotNull
    public JComponent getEditor() {
        PropagateEnableScrollPane propagateEnableScrollPane = new PropagateEnableScrollPane(this.textArea);
        Dimension dimension = this.textArea.getPreferredSize();
        propagateEnableScrollPane.setMinimumSize(new Dimension(dimension.width / 2, dimension.height));
        return propagateEnableScrollPane;
    }

    @Override
    public void reset() {
        this.textArea.setText(this.property.getValue());
    }

    @Override
    public void save() {
        this.property.setValue(this.textArea.getText());
    }

    public void saveLater() {
        SwingUtilities.invokeLater(this::save);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!this.textArea.getText().equals(propertyChangeEvent.getNewValue().toString())) {
            this.textArea.setText(propertyChangeEvent.getNewValue().toString());
        }
    }

    @Override
    public void goodBye() {
        this.property.removeValueChangeListener(this);
    }
}

