/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.settings.swing.AbstractBasicGroupEditor;
import de.caff.util.settings.swing.EditableProperty;
import de.caff.util.settings.swing.EditablePropertyGroup;
import de.caff.util.settings.swing.EditorProvider;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

class TabbedGroupEditor
extends AbstractBasicGroupEditor {
    private final JTabbedPane tabbedPane = new JTabbedPane(1, 1);

    public TabbedGroupEditor(@NotNull EditablePropertyGroup<?> editablePropertyGroup, @Nullable Locale locale) {
        super(editablePropertyGroup.getNameTag(), locale);
        Iterator<?> iterator = editablePropertyGroup.propertyIterator();
        while (iterator.hasNext()) {
            EditableProperty editableProperty = (EditableProperty)iterator.next();
            EditorProvider editorProvider = editableProperty.getEditorProvider(locale);
            this.addEditorProvider(editorProvider);
            this.tabbedPane.addTab(editorProvider.getTitleText(), new JScrollPane(editorProvider.getEditor()));
            this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, editorProvider.getToolTipText());
        }
        this.tabbedPane.addChangeListener(changeEvent -> editablePropertyGroup.setTabIndex(this.tabbedPane.getSelectedIndex()));
        this.tabbedPane.setSelectedIndex(editablePropertyGroup.getTabIndex());
    }

    @Override
    @NotNull
    public JComponent getEditor() {
        return this.tabbedPane;
    }
}

