/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Indexable;
import de.caff.i18n.I18n;
import de.caff.i18n.swing.RJButton;
import de.caff.i18n.swing.RJLabel;
import de.caff.util.Utility;
import de.caff.util.settings.UrlListPreferenceProperty;
import de.caff.util.settings.swing.AbstractBasicSimpleEditableChangeableItem;
import de.caff.util.settings.swing.EditablePreferenceProperty;
import de.caff.util.settings.swing.EditorProvider;
import de.caff.util.settings.swing.UrlListEditor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;

public class SwingUrlListPreferenceProperty
extends AbstractBasicSimpleEditableChangeableItem
implements UrlListPreferenceProperty,
EditablePreferenceProperty {
    public static final String DIALOG_TITLE = "#diTitle";
    public static final String DIALOG_BUTTON = "#diButton";
    public static final String DIALOG_LABEL = "#diLabel";
    public static final String DIALOG_FILTER = "#diFilter";
    private static final String PREF_KEY_SUFFIX_NR = "NR";
    private static final long serialVersionUID = 8150012278245474706L;
    @Nullable
    private final Indexable<String> defaults;
    @NotNull
    private List<String> urlList;
    @NotNull
    private final UrlSelectionMode selectionMode;

    public SwingUrlListPreferenceProperty(@NotNull String string, @NotNull String string2, @Nullable Collection<String> collection, @NotNull UrlSelectionMode urlSelectionMode) {
        super(string, string2);
        this.selectionMode = urlSelectionMode;
        this.urlList = collection == null ? new ArrayList<String>() : new ArrayList<String>(collection);
        this.defaults = collection == null ? null : Indexable.fromCollection(collection);
    }

    @NotNull
    public UrlSelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    @NotNull
    public EditorProvider getEditorProvider(@Nullable Locale locale) {
        return new UrlListEditor(this, locale, this.selectionMode, new Action[0]);
    }

    public void readFrom(@NotNull Preferences preferences) {
        String string = this.getBasicName();
        int n = preferences.getInt(string + PREF_KEY_SUFFIX_NR, -1);
        if (n != -1) {
            Object object;
            int n2;
            ArrayList<String> arrayList = new ArrayList<String>(this.urlList);
            this.urlList = new ArrayList<String>(n);
            for (n2 = 0; n2 < n; ++n2) {
                object = preferences.get(string + n2, null);
                if (object == null) continue;
                this.urlList.add((String)object);
            }
            if (arrayList.size() != this.urlList.size()) {
                n2 = 1;
            } else {
                object = arrayList.iterator();
                Iterator<String> iterator = this.urlList.iterator();
                n2 = 0;
                while (object.hasNext() && iterator.hasNext()) {
                    if (object.next().equals(iterator.next())) continue;
                    n2 = 1;
                    break;
                }
                int n3 = n2 = n2 != 0 || object.hasNext() ^ iterator.hasNext() ? 1 : 0;
            }
            if (n2 != 0) {
                this.fireValueChange(this.getBasicName(), arrayList, this.urlList);
            }
        }
    }

    public void storeTo(@NotNull Preferences preferences) {
        String string = this.getBasicName();
        if (this.urlList.isEmpty()) {
            preferences.putInt(string + PREF_KEY_SUFFIX_NR, 0);
        } else {
            preferences.putInt(string + PREF_KEY_SUFFIX_NR, this.urlList.size());
            int n = 0;
            for (String string2 : this.urlList) {
                if (string2 != null) {
                    preferences.put(string + n, string2);
                }
                ++n;
            }
        }
    }

    public void addUrl(String string) {
        this.addUrl(string, -1);
    }

    public void addUrl(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>(this.urlList);
        if (n < 0 && n >= this.urlList.size()) {
            this.urlList.add(string);
        } else {
            this.urlList.add(n, string);
        }
        this.fireValueChange(this.getBasicName(), arrayList, this.urlList);
    }

    public void remove(int n) {
        if (n >= 0 && n < this.urlList.size()) {
            ArrayList<String> arrayList = new ArrayList<String>(this.urlList);
            this.urlList.remove(n);
            this.fireValueChange(this.getBasicName(), arrayList, this.urlList);
        }
    }

    public void swap(int n, int n2) {
        if (n >= 0 && n < this.urlList.size() && n2 >= 0 && n2 < this.urlList.size() && n != n2) {
            ArrayList<String> arrayList = new ArrayList<String>(this.urlList);
            Collections.swap(this.urlList, n, n2);
            this.fireValueChange(this.getBasicName(), arrayList, this.urlList);
        }
    }

    public Collection<String> getUrlList() {
        return Collections.unmodifiableCollection(this.urlList);
    }

    void setUrlList(@NotNull Collection<String> collection) {
        Object object;
        boolean bl;
        if (collection.size() != this.urlList.size()) {
            bl = true;
        } else {
            object = this.urlList.iterator();
            Iterator<String> iterator = collection.iterator();
            bl = false;
            while (object.hasNext() && iterator.hasNext()) {
                if (object.next().equals(iterator.next())) continue;
                bl = true;
                break;
            }
            bl = bl || object.hasNext() ^ iterator.hasNext();
        }
        object = this.urlList;
        this.urlList = new ArrayList<String>(collection);
        if (bl) {
            this.fireValueChange(this.getBasicName(), object, this.urlList);
        }
    }

    @Nullable
    public Indexable<String> getDefaults() {
        return this.defaults;
    }

    @NotNull
    String getDialogTitle() {
        try {
            return I18n.getString((String)(this.getBaseTag() + DIALOG_TITLE));
        }
        catch (MissingResourceException missingResourceException) {
            return I18n.getString((String)"tiFontUrl");
        }
    }

    @NotNull
    JButton getDialogButton() {
        try {
            return new RJButton(this.getBaseTag() + DIALOG_BUTTON);
        }
        catch (MissingResourceException missingResourceException) {
            return new RJButton("btFontUrl");
        }
    }

    @NotNull
    JLabel getDialogLabel() {
        try {
            return new RJLabel(this.getBaseTag() + DIALOG_LABEL);
        }
        catch (MissingResourceException missingResourceException) {
            return new RJLabel("lbFontUrl");
        }
    }

    @Nullable
    FileFilter getDialogFileFilter() {
        try {
            final String string = I18n.getString((String)(this.getBaseTag() + DIALOG_FILTER));
            if (!string.isEmpty()) {
                final String[] stringArray = string.split("\\|");
                return new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (!SwingUrlListPreferenceProperty.this.selectionMode.isAllowed(file)) {
                            return false;
                        }
                        if (file.isDirectory()) {
                            return true;
                        }
                        for (String string2 : stringArray) {
                            if (!Utility.globEquals((String)string2.toLowerCase(), (String)file.getName().toLowerCase())) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public String getDescription() {
                        return string;
                    }
                };
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    public static enum UrlSelectionMode {
        FilesAndDirectories(true, true, 2),
        FilesOnly(true, false, 0),
        DirectoriesOnly(false, true, 1);

        private final boolean allowsFiles;
        private final boolean allowsDirectories;
        private final int fileSelectionMode;

        private UrlSelectionMode(boolean bl, boolean bl2, int n2) {
            this.allowsFiles = bl;
            this.allowsDirectories = bl2;
            this.fileSelectionMode = n2;
        }

        public int getFileSelectionMode() {
            return this.fileSelectionMode;
        }

        public boolean isAllowed(@NotNull File file) {
            return file.isDirectory() ? this.allowsDirectories : this.allowsFiles;
        }
    }
}

