/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.swing.RJMenu;
import de.caff.util.settings.AbstractBasicLocalizableChangeableItem;
import de.caff.util.settings.StringListPreferenceProperty;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;

public class SwingRecentFilesPreferenceProperty
extends AbstractBasicLocalizableChangeableItem
implements StringListPreferenceProperty {
    private static final long serialVersionUID = 8713487176651453571L;
    private static final String PREF_KEY_SUFFIX_NR = "NR";
    public static final int MAXIMUM_STORE_SIZE = 10;
    private final int maxSize;
    private List<String> files = new LinkedList<String>();

    public SwingRecentFilesPreferenceProperty(@NotNull String string, @NotNull String string2) {
        this(string, string2, 10);
    }

    public SwingRecentFilesPreferenceProperty(@NotNull String string, @NotNull String string2, int n) {
        super(string, string2);
        if (n > 10) {
            throw new IllegalArgumentException("maxSize parameter is too large");
        }
        this.maxSize = n;
    }

    public void addEntry(@NotNull String string) {
        ArrayList<String> arrayList = new ArrayList<String>(this.files);
        ListIterator<String> listIterator = this.files.listIterator();
        while (listIterator.hasNext()) {
            if (!string.equals(listIterator.next())) continue;
            listIterator.remove();
            break;
        }
        if (this.files.size() == this.maxSize) {
            this.files.remove(this.maxSize - 1);
        }
        this.files.add(0, string);
        this.fireValueChange(this.getBasicName(), Collections.unmodifiableCollection(arrayList), Collections.unmodifiableCollection(this.files));
    }

    public void readFrom(@NotNull Preferences preferences) {
        String string = this.getBasicName();
        int n = preferences.getInt(string + PREF_KEY_SUFFIX_NR, -1);
        if (n != -1) {
            Object object;
            int n2;
            if (n > this.maxSize) {
                n = this.maxSize;
            }
            ArrayList<String> arrayList = new ArrayList<String>(this.files);
            this.files = new ArrayList<String>(n);
            for (n2 = 0; n2 < n; ++n2) {
                object = preferences.get(string + n2, null);
                if (object == null) continue;
                this.files.add((String)object);
            }
            if (arrayList.size() != this.files.size()) {
                n2 = 1;
            } else {
                object = arrayList.iterator();
                Iterator<String> iterator = this.files.iterator();
                n2 = 0;
                while (object.hasNext() && iterator.hasNext()) {
                    if (object.next().equals(iterator.next())) continue;
                    n2 = 1;
                    break;
                }
                int n3 = n2 = n2 != 0 || object.hasNext() ^ iterator.hasNext() ? 1 : 0;
            }
            if (n2 != 0) {
                this.fireValueChange(this.getBasicName(), Collections.unmodifiableCollection(arrayList), Collections.unmodifiableCollection(this.files));
            }
        }
    }

    public void storeTo(@NotNull Preferences preferences) {
        String string = this.getBasicName();
        preferences.putInt(string + PREF_KEY_SUFFIX_NR, this.files.size());
        int n = 0;
        for (String string2 : this.files) {
            preferences.put(string + n, string2);
            ++n;
        }
    }

    @NotNull
    public List<String> getStringList() {
        return Collections.unmodifiableList(this.files);
    }

    @Nullable
    public String getLatestEntry() {
        return this.files.isEmpty() ? null : this.files.get(0);
    }

    @NotNull
    public JMenuItem getMenuItem(RecentFileLoader recentFileLoader, Locale locale) {
        SpecialMenu specialMenu = new SpecialMenu(recentFileLoader, this.getBaseTag());
        specialMenu.setLocale(locale);
        specialMenu.propertyChange(new PropertyChangeEvent((Object)this, this.getBasicName(), null, this.files));
        this.addValueChangeListenerWeakly(specialMenu);
        return specialMenu;
    }

    private static class SpecialMenu
    extends RJMenu
    implements PropertyChangeListener {
        private static final long serialVersionUID = 2253619552080450537L;
        private final RecentFileLoader loader;

        public SpecialMenu(RecentFileLoader recentFileLoader, String string) {
            super(string);
            this.loader = recentFileLoader;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.removeAll();
            Collection collection = (Collection)propertyChangeEvent.getNewValue();
            int n = 1;
            for (String string : collection) {
                String string2 = Integer.toString(n % 10);
                this.add(new FileMenuItem(string2, string));
                ++n;
            }
            this.setEnabled(!collection.isEmpty());
        }

        private class FileMenuItem
        extends JMenuItem
        implements ActionListener {
            private static final long serialVersionUID = -1836115225804583659L;
            private final String filename;

            public FileMenuItem(String string, String string2) {
                super(string + " " + string2);
                this.filename = string2;
                this.addActionListener(this);
                this.setMnemonic(string.charAt(0));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpecialMenu.this.loader.loadRecentFile(this.filename);
            }
        }
    }

    public static interface RecentFileLoader {
        public void loadRecentFile(String var1);
    }
}

