/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Types;
import de.caff.generics.function.Function1;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.swing.RJMenu;
import de.caff.util.debug.Debug;
import de.caff.util.settings.AbstractBasicLocalizableChangeableItem;
import de.caff.util.settings.StringListPreferenceProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;

public final class SwingLookAndFeelPreferenceProperty
extends AbstractBasicLocalizableChangeableItem
implements StringListPreferenceProperty {
    private static final long serialVersionUID = 6254879720735340597L;
    public static final String PROPERTY_LAF_NAME = "LAF_NAME";
    private static SwingLookAndFeelPreferenceProperty SINGLETON = null;
    private static final String KEY_LAF = "LookAndFeel";
    private static final List<UIManager.LookAndFeelInfo> LOOK_AND_FEELS = Arrays.asList(UIManager.getInstalledLookAndFeels());
    private int current;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static SwingLookAndFeelPreferenceProperty getInstance() {
        List<UIManager.LookAndFeelInfo> list = LOOK_AND_FEELS;
        synchronized (list) {
            if (SINGLETON == null) {
                SINGLETON = new SwingLookAndFeelPreferenceProperty();
            }
            return SINGLETON;
        }
    }

    private SwingLookAndFeelPreferenceProperty() {
        super("PLAF", "ppLookAndFeel");
        this.setLookAndFeel(UIManager.getLookAndFeel().getName());
    }

    public Collection<String> getStringList() {
        return Types.map(LOOK_AND_FEELS, (Function)((Function1)UIManager.LookAndFeelInfo::getName));
    }

    public UIManager.LookAndFeelInfo getCurrentLookAndFeelInfo() {
        return LOOK_AND_FEELS.get(this.current);
    }

    public void setLookAndFeel(@NotNull String string) {
        int n = 0;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : LOOK_AND_FEELS) {
            if (string.equalsIgnoreCase(lookAndFeelInfo.getName())) {
                this.setLookAndFeel(n);
                break;
            }
            ++n;
        }
    }

    private void setLookAndFeelClass(@NotNull String string) {
        int n = 0;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : LOOK_AND_FEELS) {
            if (string.equalsIgnoreCase(lookAndFeelInfo.getClassName())) {
                this.setLookAndFeel(n);
                break;
            }
            ++n;
        }
    }

    private void setLookAndFeel(int n) {
        if (n != this.current) {
            try {
                UIManager.setLookAndFeel(LOOK_AND_FEELS.get(n).getClassName());
                int n2 = this.current;
                this.current = n;
                this.fireValueChange(PROPERTY_LAF_NAME, LOOK_AND_FEELS.get(n2).getName(), LOOK_AND_FEELS.get(this.current).getName());
            }
            catch (Exception exception) {
                Debug.error((Throwable)exception);
            }
        }
    }

    public void readFrom(@NotNull Preferences preferences) {
        String string = preferences.get(KEY_LAF, null);
        if (string == null) {
            return;
        }
        this.setLookAndFeelClass(string);
    }

    public void storeTo(@NotNull Preferences preferences) {
        preferences.put(KEY_LAF, LOOK_AND_FEELS.get(this.current).getClassName());
    }

    public JMenuItem createMenuItem(Locale locale) {
        RJMenu rJMenu = new RJMenu(this.getBaseTag());
        ButtonGroup buttonGroup = new ButtonGroup();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : LOOK_AND_FEELS) {
            SpecialMenuItem specialMenuItem = new SpecialMenuItem(lookAndFeelInfo, locale);
            rJMenu.add(specialMenuItem);
            buttonGroup.add(specialMenuItem);
        }
        return rJMenu;
    }

    private class SpecialMenuItem
    extends JRadioButtonMenuItem
    implements PropertyChangeListener,
    Localizable {
        private static final long serialVersionUID = -4293561993162568951L;
        private final UIManager.LookAndFeelInfo lafInfo;

        public SpecialMenuItem(@Nullable UIManager.LookAndFeelInfo lookAndFeelInfo, Locale locale) {
            super(lookAndFeelInfo.getName(), lookAndFeelInfo == SwingLookAndFeelPreferenceProperty.this.getCurrentLookAndFeelInfo());
            this.setToolTipText(lookAndFeelInfo.getClassName());
            SwingLookAndFeelPreferenceProperty.this.addValueChangeListenerWeakly(this);
            this.lafInfo = lookAndFeelInfo;
            this.addItemListener(itemEvent -> {
                if (this.isSelected()) {
                    SwingLookAndFeelPreferenceProperty.this.setLookAndFeelClass(this.lafInfo.getClassName());
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setSelected(this.lafInfo.getName() == propertyChangeEvent.getNewValue());
        }

        @Override
        public void addNotify() {
            I18n.addLocalizationChangeListener((Localizable)this);
            super.addNotify();
            SwingLookAndFeelPreferenceProperty.this.addValueChangeListener(this);
            if (this.lafInfo == SwingLookAndFeelPreferenceProperty.this.getCurrentLookAndFeelInfo()) {
                this.setSelected(true);
            }
        }

        @Override
        public void removeNotify() {
            I18n.removeLocalizationChangeListener((Localizable)this);
            super.removeNotify();
            SwingLookAndFeelPreferenceProperty.this.removeValueChangeListener(this);
        }

        @Override
        public void setLocale(Locale locale) {
            super.setLocale(locale);
            this.setText(this.lafInfo.getName());
            this.setToolTipText(this.lafInfo.getClassName());
        }
    }
}

