/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.util.settings.LongPreferenceProperty;
import de.caff.util.settings.swing.EditablePreferenceProperty;
import de.caff.util.settings.swing.SwingNumberProperty;
import java.util.prefs.Preferences;

public class SwingLongPreferenceProperty
extends SwingNumberProperty
implements LongPreferenceProperty,
EditablePreferenceProperty {
    private static final long serialVersionUID = -198215960103289841L;
    private final long minValue;
    private final long maxValue;
    private final long step;
    private long value;

    public SwingLongPreferenceProperty(@NotNull String string, @NotNull String string2, long l) {
        this(string, string2, l, false);
    }

    public SwingLongPreferenceProperty(@NotNull String string, @NotNull String string2, long l, boolean bl) {
        this(string, string2, l, 1L);
    }

    public SwingLongPreferenceProperty(@NotNull String string, @NotNull String string2, long l, long l2) {
        this(string, string2, l, l2, false);
    }

    public SwingLongPreferenceProperty(@NotNull String string, @NotNull String string2, long l, long l2, boolean bl) {
        this(string, string2, l, Long.MIN_VALUE, Long.MAX_VALUE, l2);
    }

    public SwingLongPreferenceProperty(@NotNull String string, @NotNull String string2, long l, long l2, long l3) {
        this(string, string2, l, l2, l3, false);
    }

    public SwingLongPreferenceProperty(@NotNull String string, @NotNull String string2, long l, long l2, long l3, boolean bl) {
        this(string, string2, l, l2, l3, 1L, bl);
    }

    public SwingLongPreferenceProperty(@NotNull String string, @NotNull String string2, long l, long l2, long l3, long l4) {
        this(string, string2, l, l2, l3, l4, false);
    }

    public SwingLongPreferenceProperty(@NotNull String string, @NotNull String string2, long l, long l2, long l3, long l4, boolean bl) {
        super(string, string2, bl);
        this.minValue = l2;
        this.maxValue = l3;
        this.step = l4;
        this.value = l;
    }

    public void readFrom(@NotNull Preferences preferences) {
        this.setValue(preferences.getLong(this.getBasicName(), this.value));
    }

    public void storeTo(@NotNull Preferences preferences) {
        preferences.putLong(this.getBasicName(), this.value);
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public long getStep() {
        return this.step;
    }

    @NotNull
    public Long getValue() {
        return this.value;
    }

    public void setValue(long l) {
        long l2 = this.value;
        this.value = l > this.maxValue ? this.maxValue : (l < this.minValue ? this.minValue : l);
        if (l2 != this.value) {
            this.fireValueChange(this.getBasicName(), l2, this.value);
        }
    }

    public void setValue(@NotNull Long l) {
        this.setValue((long)l);
    }

    @Override
    @NotNull
    public Number getMinValueNumber() {
        return this.getMinValue();
    }

    @Override
    @NotNull
    public Number getMaxValueNumber() {
        return this.getMaxValue();
    }

    @Override
    @NotNull
    public Number getStepNumber() {
        return this.getStep();
    }

    @Override
    @NotNull
    public Number getValueNumber() {
        return this.getValue();
    }

    @Override
    public void setValueNumber(@NotNull Number number) {
        this.setValue(number.longValue());
    }
}

