/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.util.settings.Property;
import de.caff.util.settings.swing.SwingNumberProperty;

public class SwingIntegerProperty
extends SwingNumberProperty
implements Property<Integer> {
    private static final long serialVersionUID = 6075926052059224819L;
    private final int minValue;
    private final int maxValue;
    private final int step;
    private int value;

    public SwingIntegerProperty(String string, String string2, int n) {
        this(string, string2, n, false);
    }

    public SwingIntegerProperty(String string, String string2, int n, boolean bl) {
        this(string, string2, n, 1, bl);
    }

    public SwingIntegerProperty(String string, String string2, int n, int n2) {
        this(string, string2, n, n2, false);
    }

    public SwingIntegerProperty(String string, String string2, int n, int n2, boolean bl) {
        this(string, string2, n, Integer.MIN_VALUE, Integer.MAX_VALUE, n2, bl);
    }

    public SwingIntegerProperty(String string, String string2, int n, int n2, int n3) {
        this(string, string2, n, n2, n3, false);
    }

    public SwingIntegerProperty(String string, String string2, int n, int n2, int n3, boolean bl) {
        this(string, string2, n, n2, n3, 1, bl);
    }

    public SwingIntegerProperty(String string, String string2, int n, int n2, int n3, int n4) {
        this(string, string2, n, n2, n3, n4, false);
    }

    public SwingIntegerProperty(@NotNull String string, @NotNull String string2, int n, int n2, int n3, int n4, boolean bl) {
        super(string, string2, bl);
        this.minValue = n2;
        this.maxValue = n3;
        this.step = n4;
        this.value = n;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getStep() {
        return this.step;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(@NotNull Integer n) {
        this.setValue((int)n);
    }

    public void setValue(int n) {
        int n2 = this.value;
        this.value = n > this.maxValue ? this.maxValue : (n < this.minValue ? this.minValue : n);
        if (n2 != this.value) {
            this.fireValueChange(this.getBasicName(), n2, this.value);
        }
    }

    @Override
    @NotNull
    public Number getMinValueNumber() {
        return this.getMinValue();
    }

    @Override
    @NotNull
    public Number getMaxValueNumber() {
        return this.getMaxValue();
    }

    @Override
    @NotNull
    public Number getStepNumber() {
        return this.getStep();
    }

    @Override
    @NotNull
    public Number getValueNumber() {
        return this.getValue();
    }

    @Override
    public void setValueNumber(@NotNull Number number) {
        this.setValue(number.intValue());
    }
}

