/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.util.debug.Debug;
import de.caff.util.settings.swing.EditablePreferenceGroup;
import de.caff.util.settings.swing.SwingBooleanPreferenceProperty;
import de.caff.util.settings.swing.SwingIntegerPreferenceProperty;
import de.caff.util.settings.swing.SwingStringPreferenceProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;

public class SwingHttpProxyPropertySettings
extends EditablePreferenceGroup
implements PropertyChangeListener {
    public static final String PORT_SUFFIX = "-PORT";
    public static final String HOST_SUFFIX = "-HOST";
    public static final String USED_SUFFIX = "-USED";
    private final SwingBooleanPreferenceProperty useProxy;
    private final SwingStringPreferenceProperty proxyHost;
    private final SwingIntegerPreferenceProperty proxyPort;

    public SwingHttpProxyPropertySettings(String string, String string2) {
        super(string2, false);
        this.useProxy = new SwingBooleanPreferenceProperty(string + USED_SUFFIX, string2 + USED_SUFFIX, false);
        this.proxyHost = new SwingStringPreferenceProperty(string + HOST_SUFFIX, string2 + HOST_SUFFIX);
        this.proxyPort = new SwingIntegerPreferenceProperty(string + PORT_SUFFIX, string2 + PORT_SUFFIX, 80, 1, 65535);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            string3 = System.getProperty("proxySet");
            string4 = System.getProperty("http.proxyHost");
            string5 = System.getProperty("http.proxyPort");
        }
        catch (SecurityException securityException) {
            Debug.warn((Throwable)securityException);
            string3 = null;
        }
        if (string3 != null && Boolean.valueOf(string3).booleanValue()) {
            this.useProxy.setValue(true);
            this.proxyHost.setValue(string4);
            this.proxyPort.setValue(Integer.parseInt(string5));
        }
        this.useProxy.addValueChangeListenerWeakly(this);
        this.proxyHost.addValueChangeListenerWeakly(this);
        this.proxyPort.addValueChangeListenerWeakly(this);
        this.addProperty(this.useProxy);
        this.addProperty(this.proxyHost);
        this.addProperty(this.proxyPort);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.useProxy.getValue().booleanValue()) {
            System.setProperty("proxySet", "true");
            String string = this.proxyHost.getValue();
            System.setProperty("http.proxyHost", string != null ? string : "");
            System.setProperty("http.proxyPort", Integer.toString(this.proxyPort.getValue()));
        } else {
            Properties properties = System.getProperties();
            properties.remove("http.proxyHost");
            properties.remove("http.proxyPort");
            properties.remove("proxySet");
            System.setProperties(properties);
        }
    }
}

