/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.settings.Property;
import de.caff.util.settings.swing.AbstractBasicSimpleEditableChangeableItem;
import de.caff.util.settings.swing.EditorProvider;
import de.caff.util.settings.swing.FormattedStringEditor;
import java.util.Locale;
import javax.swing.JFormattedTextField;

public class SwingFormattedStringProperty<T>
extends AbstractBasicSimpleEditableChangeableItem
implements Property<T> {
    public static final int DEFAULT_ROWS = 40;
    private static final long serialVersionUID = -1880148426126237161L;
    protected T value;
    private final boolean autoSave;
    private final int columns;
    @NotNull
    private final JFormattedTextField.AbstractFormatter formatter;

    public SwingFormattedStringProperty(@NotNull String string, @NotNull String string2, @NotNull JFormattedTextField.AbstractFormatter abstractFormatter) {
        this(string, string2, abstractFormatter, false, null, 40);
    }

    public SwingFormattedStringProperty(@NotNull String string, @NotNull String string2, @NotNull JFormattedTextField.AbstractFormatter abstractFormatter, boolean bl, T t, int n) {
        super(string, string2);
        this.autoSave = bl;
        this.value = t;
        this.formatter = abstractFormatter;
        this.columns = n;
    }

    @Override
    @NotNull
    public EditorProvider getEditorProvider(@Nullable Locale locale) {
        return new FormattedStringEditor(this, this.autoSave, locale);
    }

    public int getColumns() {
        return this.columns;
    }

    public T getValue() {
        return this.value;
    }

    @NotNull
    public JFormattedTextField.AbstractFormatter getFormatter() {
        return this.formatter;
    }

    public void setValue(T t) {
        if (t != null ? !t.equals(this.value) : this.value != null) {
            T t2 = this.value;
            this.value = t;
            this.fireValueChange(this.getBasicName(), t2, t);
        }
    }
}

