/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Types;
import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.swing.RJMenu;
import de.caff.util.settings.EnumProperty;
import de.caff.util.settings.EnumValue;
import de.caff.util.settings.swing.AbstractBasicSimpleEditableChangeableItem;
import de.caff.util.settings.swing.EditorProvider;
import de.caff.util.settings.swing.EnumEditor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class SwingEnumProperty<E>
extends AbstractBasicSimpleEditableChangeableItem
implements EnumProperty<E> {
    private static final long serialVersionUID = -910957808821606537L;
    private final List<EnumValue<E>> values;
    private EnumValue<E> selectedValue;
    private EnumValueComparator<E> enumValueComparator;
    private final boolean autoSave;

    public SwingEnumProperty(@NotNull EnumValue<E> enumValue, @NotNull String string, @NotNull String string2, EnumValue<E> ... enumValueArray) {
        this(enumValue, string, string2, Types.asList((Object[])enumValueArray));
    }

    public SwingEnumProperty(@NotNull EnumValue<E> enumValue, boolean bl, @NotNull String string, @NotNull String string2, EnumValue<E> ... enumValueArray) {
        this(enumValue, bl, string, string2, Types.asList((Object[])enumValueArray));
    }

    public SwingEnumProperty(@NotNull EnumValue<E> enumValue, @NotNull String string, @NotNull String string2, @NotNull Collection<EnumValue<E>> collection) {
        this(enumValue, false, string, string2, collection);
    }

    public SwingEnumProperty(@NotNull EnumValue<E> enumValue, boolean bl, @NotNull String string, @NotNull String string2, @NotNull Collection<EnumValue<E>> collection) {
        super(string, string2);
        this.values = new ArrayList<EnumValue<EnumValue<E>>>(collection);
        this.selectedValue = enumValue;
        this.autoSave = bl;
    }

    public SwingEnumProperty(@NotNull EnumValue<E> enumValue, @NotNull String string, @NotNull String string2, @NotNull EnumValueComparator<E> enumValueComparator, EnumValue<E> ... enumValueArray) {
        this(enumValue, string, string2, enumValueArray);
        this.enumValueComparator = enumValueComparator;
    }

    public SwingEnumProperty(@NotNull EnumValue<E> enumValue, boolean bl, @NotNull String string, @NotNull String string2, @NotNull EnumValueComparator<E> enumValueComparator, EnumValue<E> ... enumValueArray) {
        this(enumValue, bl, string, string2, enumValueArray);
        this.enumValueComparator = enumValueComparator;
    }

    public SwingEnumProperty(@NotNull EnumValue<E> enumValue, @NotNull String string, @NotNull String string2, @NotNull EnumValueComparator<E> enumValueComparator, @NotNull Collection<EnumValue<E>> collection) {
        this(enumValue, string, string2, collection);
        this.enumValueComparator = enumValueComparator;
    }

    public SwingEnumProperty(@NotNull EnumValue<E> enumValue, boolean bl, @NotNull String string, @NotNull String string2, @NotNull EnumValueComparator<E> enumValueComparator, @NotNull Collection<EnumValue<E>> collection) {
        this(enumValue, bl, string, string2, collection);
        this.enumValueComparator = enumValueComparator;
    }

    @Override
    @NotNull
    public EditorProvider getEditorProvider(@Nullable Locale locale) {
        return new EnumEditor(this, this.autoSave, locale);
    }

    @NotNull
    public EnumValue<E> getValue() {
        return this.selectedValue;
    }

    public void setValue(EnumValue<E> enumValue) {
        if (!enumValue.equals(this.selectedValue)) {
            EnumValue<E> enumValue2 = this.selectedValue;
            this.selectedValue = enumValue;
            this.fireValueChange(this.getBasicName(), enumValue2, enumValue);
        }
    }

    @NotNull
    public List<EnumValue<E>> getEnumValues(Locale locale) {
        return this.getEnumValues();
    }

    @NotNull
    protected List<EnumValue<E>> getEnumValues() {
        return Collections.unmodifiableList(this.values);
    }

    EnumValueComparator<E> getEnumValueComparator() {
        return this.enumValueComparator;
    }

    public JMenuItem createMenuItem(Locale locale) {
        RJMenu rJMenu = new RJMenu(this.getBaseTag());
        ButtonGroup buttonGroup = new ButtonGroup();
        for (EnumValue<E> enumValue : this.values) {
            SpecialMenuItem specialMenuItem = new SpecialMenuItem(enumValue, locale);
            rJMenu.add(specialMenuItem);
            buttonGroup.add(specialMenuItem);
        }
        return rJMenu;
    }

    public static <T> EnumValueComparator<T> getShortNameEnumValueComparator() {
        return new EnumValueComparator<T>(){
            private Locale locale;

            @Override
            public void setLocale(Locale locale) {
                this.locale = locale;
            }

            @Override
            public int compare(EnumValue<T> enumValue, EnumValue<T> enumValue2) {
                return enumValue.getShortName(this.locale).compareToIgnoreCase(enumValue2.getShortName(this.locale));
            }
        };
    }

    public static interface EnumValueComparator<T>
    extends Comparator<EnumValue<T>> {
        public void setLocale(Locale var1);
    }

    private class SpecialMenuItem
    extends JRadioButtonMenuItem
    implements PropertyChangeListener,
    Localizable {
        private static final long serialVersionUID = 3230453897448041768L;
        private final EnumValue<E> value;

        public SpecialMenuItem(EnumValue<E> enumValue, Locale locale) {
            super(enumValue.getShortName(locale), enumValue == SwingEnumProperty.this.getValue());
            this.setToolTipText(enumValue.getLongName(locale));
            SwingEnumProperty.this.addValueChangeListenerWeakly(this);
            this.value = enumValue;
            this.addItemListener(itemEvent -> {
                if (this.isSelected()) {
                    SwingEnumProperty.this.setValue(this.value);
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setSelected(this.value == propertyChangeEvent.getNewValue());
        }

        @Override
        public void addNotify() {
            I18n.addLocalizationChangeListener((Localizable)this);
            super.addNotify();
            SwingEnumProperty.this.addValueChangeListener(this);
            if (this.value == SwingEnumProperty.this.getValue()) {
                this.setSelected(true);
            }
        }

        @Override
        public void removeNotify() {
            I18n.removeLocalizationChangeListener((Localizable)this);
            super.removeNotify();
            SwingEnumProperty.this.removeValueChangeListener(this);
        }

        @Override
        public void setLocale(Locale locale) {
            super.setLocale(locale);
            this.setText(this.value.getShortName(locale));
            this.setToolTipText(this.value.getLongName(locale));
        }
    }
}

