/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.util.settings.Property;
import de.caff.util.settings.swing.SwingNumberProperty;

public class SwingDoubleProperty
extends SwingNumberProperty
implements Property<Double> {
    private static final long serialVersionUID = -635152081189321398L;
    private final double minValue;
    private final double maxValue;
    private final double step;
    private double value;

    public SwingDoubleProperty(@NotNull String string, @NotNull String string2, double d) {
        this(string, string2, d, false);
    }

    public SwingDoubleProperty(@NotNull String string, @NotNull String string2, double d, boolean bl) {
        this(string, string2, d, 1.0, bl);
    }

    public SwingDoubleProperty(@NotNull String string, @NotNull String string2, double d, double d2) {
        this(string, string2, d, d2, false);
    }

    public SwingDoubleProperty(@NotNull String string, @NotNull String string2, double d, double d2, boolean bl) {
        this(string, string2, d, -1.7976931348623157E308, Double.MAX_VALUE, d2, bl);
    }

    public SwingDoubleProperty(@NotNull String string, @NotNull String string2, double d, double d2, double d3) {
        this(string, string2, d, d2, d3, false);
    }

    public SwingDoubleProperty(@NotNull String string, @NotNull String string2, double d, double d2, double d3, boolean bl) {
        this(string, string2, d, d2, d3, 1.0, bl);
    }

    public SwingDoubleProperty(@NotNull String string, @NotNull String string2, double d, double d2, double d3, double d4) {
        this(string, string2, d, d2, d3, d4, false);
    }

    public SwingDoubleProperty(@NotNull String string, @NotNull String string2, double d, double d2, double d3, double d4, boolean bl) {
        super(string, string2, bl);
        this.minValue = d2;
        this.maxValue = d3;
        this.step = d4;
        this.value = d;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getStep() {
        return this.step;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(@NotNull Double d) {
        this.setValue((double)d);
    }

    public void setValue(double d) {
        double d2 = this.value;
        this.value = d > this.maxValue ? this.maxValue : (d < this.minValue ? this.minValue : d);
        if (d2 != this.value) {
            this.fireValueChange(this.getBasicName(), d2, this.value);
        }
    }

    @Override
    @NotNull
    public Number getMinValueNumber() {
        return this.getMinValue();
    }

    @Override
    @NotNull
    public Number getMaxValueNumber() {
        return this.getMaxValue();
    }

    @Override
    @NotNull
    public Number getStepNumber() {
        return this.getStep();
    }

    @Override
    @NotNull
    public Number getValueNumber() {
        return this.getValue();
    }

    @Override
    public void setValueNumber(@NotNull Number number) {
        this.setValue(number.doubleValue());
    }
}

