/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.settings.DirectoryPreferenceProperty;
import de.caff.util.settings.swing.AbstractBasicSimpleEditableChangeableItem;
import de.caff.util.settings.swing.DirectoryEditor;
import de.caff.util.settings.swing.EditablePreferenceProperty;
import de.caff.util.settings.swing.EditorProvider;
import java.io.File;
import java.util.Locale;
import java.util.prefs.Preferences;

public class SwingDirectoryPreferenceProperty
extends AbstractBasicSimpleEditableChangeableItem
implements DirectoryPreferenceProperty,
EditablePreferenceProperty {
    private static final long serialVersionUID = -3313212683306473948L;
    private File directory;

    public SwingDirectoryPreferenceProperty(@NotNull String string, @NotNull String string2, @Nullable File file) {
        super(string, string2);
        this.directory = file;
    }

    public void readFrom(@NotNull Preferences preferences) {
        String string = preferences.get(this.getBasicName(), null);
        if (string != null) {
            this.setDirectory(new File(string));
        }
    }

    public void storeTo(@NotNull Preferences preferences) {
        if (this.directory == null) {
            preferences.remove(this.getBasicName());
        } else {
            preferences.put(this.getBasicName(), this.directory.getPath());
        }
    }

    @Override
    @NotNull
    public EditorProvider getEditorProvider(@Nullable Locale locale) {
        return new DirectoryEditor(this, locale);
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File file) {
        if (file != null ? !file.equals(this.directory) : this.directory != null) {
            File file2 = this.directory;
            this.directory = file;
            this.fireValueChange(this.getBasicName(), file2, file);
        }
    }
}

