/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.swing.RJMenuItem;
import de.caff.util.settings.Property;
import de.caff.util.settings.swing.AbstractBasicSimpleEditableChangeableItem;
import de.caff.util.settings.swing.ColorEditor;
import de.caff.util.settings.swing.EditorProvider;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JMenuItem;

public class SwingColorProperty
extends AbstractBasicSimpleEditableChangeableItem
implements Property<Color> {
    private static final long serialVersionUID = -375223870683758152L;
    protected final boolean autoSave;
    protected Color value;

    public SwingColorProperty(@NotNull String string, @NotNull String string2, boolean bl, @NotNull Color color) {
        super(string, string2);
        this.autoSave = bl;
        this.value = color;
    }

    @Override
    @NotNull
    public EditorProvider getEditorProvider(@Nullable Locale locale) {
        return new ColorEditor(this, locale, this.autoSave);
    }

    public Color getValue() {
        return this.value;
    }

    public void setValue(Color color) {
        if (color != null ? !color.equals(this.value) : this.value != null) {
            Color color2 = this.value;
            this.value = color;
            this.fireValueChange(this.getBasicName(), color2, color);
        }
    }

    public JMenuItem createMenuItem(@NotNull String string, @NotNull Color color, @Nullable Locale locale) {
        return new SpecialMenuItem(string, color, locale);
    }

    private class SpecialMenuItem
    extends RJMenuItem
    implements PropertyChangeListener {
        private static final long serialVersionUID = 5617140937616415191L;
        private final Color color;

        public SpecialMenuItem(String string, Color color, Locale locale) {
            super(string, locale);
            this.color = color;
            this.setIcon(ColorEditor.createColoredIcon(color));
            this.addActionListener(actionEvent -> SwingColorProperty.this.setValue(this.color));
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Color color = (Color)propertyChangeEvent.getNewValue();
            this.handleNewColor(color);
        }

        private void handleNewColor(Color color) {
            this.setEnabled(!this.color.equals(color));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            SwingColorProperty.this.addValueChangeListener(this);
            this.handleNewColor(SwingColorProperty.this.getValue());
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            SwingColorProperty.this.removeValueChangeListener(this);
        }
    }
}

