/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.swing.RJCheckBoxMenuItem;
import de.caff.util.settings.Property;
import de.caff.util.settings.swing.AbstractBasicSimpleEditableChangeableItem;
import de.caff.util.settings.swing.BooleanEditor;
import de.caff.util.settings.swing.EditorProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.JMenuItem;

public class SwingBooleanProperty
extends AbstractBasicSimpleEditableChangeableItem
implements Property<Boolean> {
    private static final long serialVersionUID = 6793470999877380631L;
    private final boolean autoSave;
    private boolean value;

    public SwingBooleanProperty(@NotNull String string, @NotNull String string2, boolean bl, boolean bl2) {
        super(string, string2);
        this.autoSave = bl;
        this.value = bl2;
    }

    @Override
    @NotNull
    public EditorProvider getEditorProvider(@Nullable Locale locale) {
        return new BooleanEditor(this, locale);
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public Boolean getValue() {
        return this.value;
    }

    public void setValue(@NotNull Boolean bl) {
        this.setValue((boolean)bl);
    }

    public void setValue(boolean bl) {
        if (this.value != bl) {
            this.value = bl;
            this.fireValueChange(this.getBasicName(), !bl, bl);
        }
    }

    public JMenuItem createMenuItem(Locale locale) {
        SpecialMenuItem specialMenuItem = new SpecialMenuItem();
        specialMenuItem.setLocale(locale);
        return specialMenuItem;
    }

    private class SpecialMenuItem
    extends RJCheckBoxMenuItem
    implements PropertyChangeListener {
        private static final long serialVersionUID = 3003396281177599035L;

        public SpecialMenuItem() {
            super(SwingBooleanProperty.this.getBaseTag(), SwingBooleanProperty.this.getValue());
            this.addItemListener(itemEvent -> SwingBooleanProperty.this.setValue(this.isSelected()));
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setSelected((Boolean)propertyChangeEvent.getNewValue());
        }

        @Override
        public void addNotify() {
            super.addNotify();
            SwingBooleanProperty.this.addValueChangeListener(this);
            this.setSelected(SwingBooleanProperty.this.getValue());
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            SwingBooleanProperty.this.removeValueChangeListener(this);
        }
    }
}

