/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.i18n.swing.RJButton;
import de.caff.util.settings.BoundsPreferenceProperty;
import de.caff.util.settings.swing.EditorProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class SettingsDialog
extends JDialog {
    private static final long serialVersionUID = 8834918186045917419L;
    private final EditorProvider editorProvider;

    public SettingsDialog(@NotNull JComponent jComponent, @NotNull String string, final @NotNull BoundsPreferenceProperty boundsPreferenceProperty, @NotNull EditorProvider editorProvider) {
        super(SettingsDialog.getFrameAncestor(jComponent), string, true);
        this.editorProvider = editorProvider;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)editorProvider.getEditor(), "Center");
        RJButton rJButton = new RJButton("Ok");
        RJButton rJButton2 = new RJButton("Cancel");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(rJButton);
        box.add(rJButton2);
        box.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)box, "South");
        rJButton.addActionListener(actionEvent -> this.ok(boundsPreferenceProperty));
        rJButton2.addActionListener(actionEvent -> this.cancel(boundsPreferenceProperty));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SettingsDialog.this.cancel(boundsPreferenceProperty);
            }
        });
        this.setDefaultCloseOperation(0);
        if (!boundsPreferenceProperty.setWindowBounds((Window)this)) {
            this.pack();
            this.setLocationRelativeTo(jComponent);
        }
    }

    @Nullable
    private static Frame getFrameAncestor(@NotNull JComponent jComponent) {
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private void ok(@NotNull BoundsPreferenceProperty boundsPreferenceProperty) {
        this.editorProvider.save();
        this.dispose(boundsPreferenceProperty);
    }

    private void cancel(@NotNull BoundsPreferenceProperty boundsPreferenceProperty) {
        this.dispose(boundsPreferenceProperty);
    }

    public void dispose(@NotNull BoundsPreferenceProperty boundsPreferenceProperty) {
        boundsPreferenceProperty.setBounds((Window)this);
        this.editorProvider.goodBye();
        super.dispose();
    }
}

