/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.settings.swing.AbstractBasicGroupEditor;
import de.caff.util.settings.swing.EditableProperty;
import de.caff.util.settings.swing.EditablePropertyGroup;
import de.caff.util.settings.swing.EditorProvider;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

class PanelGroupEditor
extends AbstractBasicGroupEditor {
    private final JPanel panel;

    public PanelGroupEditor(@NotNull EditablePropertyGroup<? extends EditableProperty> editablePropertyGroup, @Nullable Locale locale) {
        super(editablePropertyGroup.getNameTag(), locale);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(6, 4, 6, 4);
        gridBagConstraints.gridy = 0;
        this.panel = new JPanel(gridBagLayout);
        Iterator<? extends EditableProperty> iterator = editablePropertyGroup.propertyIterator();
        while (iterator.hasNext()) {
            String string;
            EditableProperty editableProperty = iterator.next();
            EditorProvider editorProvider = editableProperty.getEditorProvider(locale);
            this.addEditorProvider(editorProvider);
            gridBagConstraints.gridx = 0;
            JComponent jComponent = editorProvider.getLabel();
            if (jComponent != null) {
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagLayout.setConstraints(jComponent, gridBagConstraints);
                this.panel.add(jComponent);
                jComponent.setToolTipText(editorProvider.getToolTipText());
                ++gridBagConstraints.gridx;
                gridBagConstraints.anchor = 12;
                gridBagConstraints.gridwidth = 0;
            } else {
                gridBagConstraints.anchor = 11;
                gridBagConstraints.gridwidth = 2;
            }
            gridBagConstraints.fill = 1;
            JComponent jComponent2 = editorProvider.getEditor();
            gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
            this.panel.add(jComponent2);
            jComponent2.setToolTipText(editorProvider.getToolTipText());
            if (jComponent == null && (string = editorProvider.getTitleText()) != null) {
                jComponent2.setBorder(BorderFactory.createTitledBorder(string));
            }
            ++gridBagConstraints.gridy;
        }
    }

    @Override
    @NotNull
    public JComponent getEditor() {
        return this.panel;
    }
}

