/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.debug.Debug;
import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingNumberProperty;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class NumberEditor
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private static final int PREFERRED_WIDTH = 60;
    private static final int MINIMUM_WIDTH = 24;
    @Nullable
    protected final JSpinner spinner;
    @Nullable
    protected final JFormattedTextField field;
    @NotNull
    protected final JComponent editor;
    @NotNull
    protected final SwingNumberProperty propertySwing;

    public NumberEditor(@NotNull SwingNumberProperty swingNumberProperty, Locale locale, boolean bl) {
        super(swingNumberProperty, locale);
        this.propertySwing = swingNumberProperty;
        if (swingNumberProperty.getStepNumber().doubleValue() < 0.0) {
            this.spinner = null;
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            this.field = new JFormattedTextField(numberFormat);
            this.field.setValue(swingNumberProperty.getValueNumber());
            Dimension dimension = this.field.getPreferredSize();
            this.field.setPreferredSize(new Dimension(60, dimension.height));
            this.editor = this.field;
            if (bl) {
                this.field.getDocument().addDocumentListener(new DocumentListener(){

                    private void possiblySave() {
                        if (NumberEditor.this.field.isValid()) {
                            NumberEditor.this.save();
                        }
                    }

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.possiblySave();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.possiblySave();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.possiblySave();
                    }
                });
            }
        } else {
            this.spinner = new JSpinner(new SpinnerNumberModel(swingNumberProperty.getValueNumber(), (Comparable)((Object)swingNumberProperty.getMinValueNumber()), (Comparable)((Object)swingNumberProperty.getMaxValueNumber()), swingNumberProperty.getStepNumber()));
            this.field = null;
            this.editor = this.spinner;
            Dimension dimension = this.spinner.getPreferredSize();
            if (dimension.width > 60) {
                this.spinner.setPreferredSize(new Dimension(60, dimension.height));
                this.spinner.setMinimumSize(new Dimension(24, dimension.height));
            }
            if (bl) {
                this.spinner.addChangeListener(changeEvent -> this.save());
            }
        }
        swingNumberProperty.addValueChangeListenerWeakly(this);
    }

    @Override
    @NotNull
    public JComponent getEditor() {
        return this.editor;
    }

    @Override
    public void reset() {
        if (this.spinner != null) {
            this.spinner.setValue(this.propertySwing.getValueNumber());
        }
        if (this.field != null) {
            this.field.setValue(this.propertySwing.getValueNumber());
        }
    }

    private Number getEditorValue() {
        if (this.spinner != null) {
            return (Number)this.spinner.getValue();
        }
        assert (this.field != null);
        return (Number)this.field.getValue();
    }

    private void setEditorValue(Object object) {
        if (this.spinner != null) {
            this.spinner.setValue(object);
        } else {
            assert (this.field != null);
            try {
                this.field.setValue(object);
            }
            catch (IllegalStateException illegalStateException) {
                Debug.trace((Throwable)illegalStateException);
            }
        }
    }

    @Override
    public void save() {
        this.propertySwing.setValueNumber(this.getEditorValue());
    }

    @Override
    public void goodBye() {
        this.propertySwing.removeValueChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (!object.equals(this.getEditorValue())) {
            this.setEditorValue(object);
        }
    }
}

